/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.common.item;

import li.cil.oc.OpenComputers$;
import li.cil.oc.api.Network;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Connector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Debugger$
implements Environment {
    public static final Debugger$ MODULE$;
    private Node node;

    static {
        new Debugger$();
    }

    @Override
    public Node node() {
        return this.node;
    }

    public void node_$eq(Node x$1) {
        this.node = x$1;
    }

    @Override
    public void onConnect(Node node2) {
        OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[NETWORK DEBUGGER] New node in network: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nodeInfo(node2)})));
    }

    @Override
    public void onDisconnect(Node node2) {
        OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[NETWORK DEBUGGER] Node removed from network: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.nodeInfo(node2)})));
    }

    @Override
    public void onMessage(Message message) {
        OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[NETWORK DEBUGGER] Received message: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.messageInfo(message)})));
    }

    public void reconnect(Node[] nodes2) {
        this.node().remove();
        Network.joinNewNetwork(this.node());
        Predef$.MODULE$.refArrayOps((Object[])nodes2).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Node node2) {
                return node2 != null;
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Node node2) {
                Debugger$.MODULE$.node().connect(node2);
            }
        });
    }

    private String nodeInfo(Node node2) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{address = ", ", reachability = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node2.address(), node2.reachability().name()})));
        Node node3 = node2;
        if (node3 instanceof ComponentConnector) {
            ComponentConnector componentConnector = (ComponentConnector)node3;
            object = new StringBuilder().append((Object)this.componentInfo(componentConnector)).append((Object)this.connectorInfo(componentConnector)).toString();
        } else if (node3 instanceof Component) {
            Component component = (Component)node3;
            object = this.componentInfo(component);
        } else if (node3 instanceof Connector) {
            Connector connector = (Connector)node3;
            object = this.connectorInfo(connector);
        } else {
            object = BoxedUnit.UNIT;
        }
        return stringBuilder.append(object).append((Object)"}").toString();
    }

    private String componentInfo(Component component) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", type = component, name = ", ", visibility = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{component.name(), component.visibility().name()}));
    }

    private String connectorInfo(Connector connector) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", type = connector, buffer = ", ", bufferSize = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)connector.localBuffer()), BoxesRunTime.boxToDouble((double)connector.localBufferSize())}));
    }

    private String messageInfo(Message message) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{name = ", ", source = ", ", data = [", "]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.name(), this.nodeInfo(message.source()), Predef$.MODULE$.refArrayOps(message.data()).mkString(", ")}));
    }

    private Debugger$() {
        MODULE$ = this;
        this.node = Network.newNode(this, Visibility.Network).create();
    }
}

