/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.forestry;

import cpw.mods.fml.common.Loader;
import forestry.api.apiculture.IBeeHousing;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.machines.basic.MTEIndustrialApiary;
import li.cil.oc.util.BlockPosition;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class UpgradeBeekeeperUtil {
    private static final boolean GT_LOADED = Loader.isModLoaded((String)"gregtech");

    private UpgradeBeekeeperUtil() {
    }

    public static IBeeHousing getBeeHousingAt(BlockPosition pos) {
        if (pos.world().isEmpty()) {
            return null;
        }
        World world = (World)pos.world().get();
        TileEntity te = world.func_147438_o(pos.x(), pos.y(), pos.z());
        if (te == null) {
            return null;
        }
        if (te instanceof IBeeHousing) {
            return (IBeeHousing)te;
        }
        if (!GT_LOADED) {
            return null;
        }
        if (!(te instanceof BaseMetaTileEntity)) {
            return null;
        }
        BaseMetaTileEntity mte = (BaseMetaTileEntity)te;
        if (!(mte.getMetaTileEntity() instanceof MTEIndustrialApiary)) {
            return null;
        }
        return (IBeeHousing)mte.getMetaTileEntity();
    }

    public static MTEIndustrialApiary getGTIApiaryAt(BlockPosition pos) {
        if (!GT_LOADED || pos.world().isEmpty()) {
            return null;
        }
        World world = (World)pos.world().get();
        TileEntity te = world.func_147438_o(pos.x(), pos.y(), pos.z());
        if (te == null) {
            return null;
        }
        if (!(te instanceof BaseMetaTileEntity)) {
            return null;
        }
        BaseMetaTileEntity mte = (BaseMetaTileEntity)te;
        if (!(mte.getMetaTileEntity() instanceof MTEIndustrialApiary)) {
            return null;
        }
        return (MTEIndustrialApiary)mte.getMetaTileEntity();
    }

    public static boolean swapQueen(BlockPosition pos, IInventory hostInv, int slot) {
        IBeeHousing housing = UpgradeBeekeeperUtil.getBeeHousingAt(pos);
        if (housing == null) {
            return false;
        }
        ItemStack newQueen = hostInv.func_70301_a(slot);
        ItemStack oldQueen = housing.getBeeInventory().getQueen();
        housing.getBeeInventory().setQueen(newQueen);
        hostInv.func_70299_a(slot, oldQueen);
        return true;
    }

    public static boolean swapDrone(BlockPosition pos, IInventory hostInv, int slot) {
        IBeeHousing housing = UpgradeBeekeeperUtil.getBeeHousingAt(pos);
        if (housing == null) {
            return false;
        }
        ItemStack newDrone = hostInv.func_70301_a(slot);
        ItemStack oldDrone = housing.getBeeInventory().getDrone();
        housing.getBeeInventory().setDrone(newDrone);
        hostInv.func_70299_a(slot, oldDrone);
        return true;
    }

    public static int getMaxIndustrialUpgradeCount() {
        if (!GT_LOADED) {
            return 0;
        }
        return MTEIndustrialApiary.getMaxUpgradeCount();
    }

    public static int addIndustrialUpgrade(BlockPosition pos, IInventory hostInv, int slot, int amount) {
        MTEIndustrialApiary iapiary = UpgradeBeekeeperUtil.getGTIApiaryAt(pos);
        if (iapiary == null || amount <= 0) {
            return 0;
        }
        ItemStack stackToInstall = hostInv.func_70301_a(slot);
        if (stackToInstall == null) {
            return 0;
        }
        amount = Math.min(amount, stackToInstall.field_77994_a);
        ItemStack stackToTryPush = stackToInstall.func_77979_a(amount);
        iapiary.addUpgrade(stackToTryPush);
        int itemsPushed = amount - stackToTryPush.field_77994_a;
        stackToInstall.field_77994_a += stackToTryPush.field_77994_a;
        return itemsPushed;
    }

    public static ItemStack getIndustrialUpgrade(BlockPosition pos, int index) {
        if (index < 1 || index > UpgradeBeekeeperUtil.getMaxIndustrialUpgradeCount()) {
            return null;
        }
        MTEIndustrialApiary iapiary = UpgradeBeekeeperUtil.getGTIApiaryAt(pos);
        if (iapiary == null) {
            return null;
        }
        return iapiary.getUpgrade(index - 1);
    }

    public static int removeIndustrialUpgrade(BlockPosition pos, IInventory hostInv, int slot, int index, int amount) {
        if (index < 1 || index > UpgradeBeekeeperUtil.getMaxIndustrialUpgradeCount() || amount <= 0) {
            return 0;
        }
        MTEIndustrialApiary iapiary = UpgradeBeekeeperUtil.getGTIApiaryAt(pos);
        if (iapiary == null) {
            return 0;
        }
        ItemStack stack = iapiary.getUpgrade(index - 1);
        if (stack == null) {
            return 0;
        }
        stack = stack.func_77946_l();
        amount = Math.min(amount, stack.field_77994_a);
        int moved = UpgradeBeekeeperUtil.insertIntoHostInv(hostInv, slot, stack.func_77979_a(amount));
        iapiary.removeUpgrade(index - 1, moved);
        return moved;
    }

    private static int insertIntoHostInv(IInventory hostInv, int slot, ItemStack stack) {
        int i;
        if (stack == null) {
            return 0;
        }
        int initialStackSize = stack.field_77994_a;
        UpgradeBeekeeperUtil.insertIntoSlot(hostInv, slot, stack);
        if (stack.field_77994_a <= 0) {
            return initialStackSize;
        }
        for (i = 0; i < hostInv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = hostInv.func_70301_a(i);
            if (!GTUtility.areStacksEqual((ItemStack)stack, (ItemStack)stackInSlot)) continue;
            UpgradeBeekeeperUtil.insertIntoSlot(hostInv, i, stack);
            if (stack.field_77994_a > 0) continue;
            return initialStackSize;
        }
        for (i = 0; i < hostInv.func_70302_i_(); ++i) {
            UpgradeBeekeeperUtil.insertIntoSlot(hostInv, i, stack);
            if (stack.field_77994_a > 0) continue;
            return initialStackSize;
        }
        return initialStackSize - stack.field_77994_a;
    }

    private static void insertIntoSlot(IInventory inv, int slot, ItemStack stack) {
        int toMove;
        ItemStack stackInSlot = inv.func_70301_a(slot);
        int maxStackSize = Math.min(inv.func_70297_j_(), stack.func_77976_d());
        if (stackInSlot == null) {
            inv.func_70299_a(slot, stack.func_77979_a(Math.min(maxStackSize, stack.field_77994_a)));
        } else if (GTUtility.areStacksEqual((ItemStack)stack, (ItemStack)stackInSlot) && (toMove = Math.min(stack.field_77994_a, Math.max(0, maxStackSize - stackInSlot.field_77994_a))) > 0) {
            stackInSlot.field_77994_a += toMove;
            stack.field_77994_a -= toMove;
        }
    }
}

