/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.IExecutable;
import openmods.utils.Stack;

public class CompiledFunction<E>
extends FixedCallable<E> {
    private final IExecutable<E> body;
    private final Frame<E> scope;

    public CompiledFunction(int argCount, int resultCount, IExecutable<E> body, Frame<E> scope) {
        super(argCount, resultCount);
        this.body = body;
        this.scope = scope;
    }

    @Override
    public void call(Frame<E> frame) {
        Frame<E> newFrame = FrameFactory.newLocalFrameWithSubstack(this.scope, this.argCount);
        Stack<E> resultStack = newFrame.stack();
        for (int i = 0; i < this.argCount; ++i) {
            E arg = resultStack.pop();
            newFrame.symbols().put("_" + (i + 1), arg);
        }
        this.body.execute(newFrame);
        resultStack.checkSizeIsExactly(this.resultCount);
    }
}

