/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import openmods.calc.ExecutableList;
import openmods.calc.IExecutable;
import openmods.calc.parsing.IAstParser;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.ITokenStreamCompiler;
import openmods.calc.parsing.Token;

public class AstCompiler<E>
implements ITokenStreamCompiler<E> {
    private final ICompilerState<E> initialCompilerState;

    public AstCompiler(ICompilerState<E> initialCompilerState) {
        this.initialCompilerState = initialCompilerState;
    }

    @Override
    public IExecutable<E> compile(PeekingIterator<Token> input) {
        IAstParser<E> parser = this.initialCompilerState.getParser();
        IExprNode<E> rootNode = parser.parse(this.initialCompilerState, input);
        ArrayList output = Lists.newArrayList();
        rootNode.flatten(output);
        return ExecutableList.wrap(output);
    }
}

