/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.parsing;

import com.google.common.collect.Maps;
import java.util.Map;
import openmods.calc.OperatorDictionary;
import openmods.calc.parsing.DefaultExecutableListBuilder;
import openmods.calc.parsing.IPostfixCompilerState;
import openmods.calc.parsing.IValueParser;
import openmods.calc.parsing.PostfixCompiler;
import openmods.calc.parsing.SimplePostfixCompilerState;

public class DefaultPostfixCompiler<E>
extends PostfixCompiler<E> {
    private final IValueParser<E> valueParser;
    private final OperatorDictionary<E> operators;
    private final Map<String, IStateProvider<E>> modifierStates = Maps.newHashMap();
    private final Map<String, IStateProvider<E>> bracketStates = Maps.newHashMap();

    public DefaultPostfixCompiler(IValueParser<E> valueParser, OperatorDictionary<E> operators) {
        this.valueParser = valueParser;
        this.operators = operators;
    }

    @Override
    protected IPostfixCompilerState<E> createInitialState() {
        return new SimplePostfixCompilerState<E>(new DefaultExecutableListBuilder<E>(this.valueParser, this.operators));
    }

    @Override
    protected IPostfixCompilerState<E> createStateForModifier(String modifier) {
        IStateProvider<E> stateProvider = this.modifierStates.get(modifier);
        return stateProvider != null ? stateProvider.createState() : super.createStateForModifier(modifier);
    }

    public DefaultPostfixCompiler<E> addModifierStateProvider(String modifier, IStateProvider<E> stateProvider) {
        this.modifierStates.put(modifier, stateProvider);
        return this;
    }

    @Override
    protected IPostfixCompilerState<E> createStateForBracket(String bracket) {
        IStateProvider<E> stateProvider = this.bracketStates.get(bracket);
        return stateProvider != null ? stateProvider.createState() : super.createStateForBracket(bracket);
    }

    public DefaultPostfixCompiler<E> addBracketStateProvider(String modifier, IStateProvider<E> stateProvider) {
        this.bracketStates.put(modifier, stateProvider);
        return this;
    }

    public static interface IStateProvider<E> {
        public IPostfixCompilerState<E> createState();
    }
}

