/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.bigint;

import java.math.BigInteger;
import openmods.calc.IValuePrinter;
import openmods.calc.PositionalNotationPrinter;
import openmods.calc.PrinterUtils;
import openmods.config.simpler.Configurable;
import org.apache.commons.lang3.tuple.Pair;

public class BigIntPrinter
implements IValuePrinter<BigInteger> {
    private final PositionalNotationPrinter<BigInteger> printer = new Helper(0);
    @Configurable
    public int base = 10;
    @Configurable
    public boolean uniformBaseNotation = false;

    @Override
    public String str(BigInteger value) {
        if (this.base < 2) {
            return "invalid radix";
        }
        return PrinterUtils.decorateBase(!this.uniformBaseNotation, this.base, this.base <= 36 ? value.toString(this.base) : this.printer.toString(value, this.base));
    }

    @Override
    public String repr(BigInteger value) {
        return this.str(value);
    }

    public static class Helper
    extends PositionalNotationPrinter<BigInteger> {
        public Helper(int maxDigits) {
            super(maxDigits);
        }

        @Override
        protected Pair<BigInteger, BigInteger> splitNumber(BigInteger value) {
            return Pair.of((Object)value, null);
        }

        @Override
        protected PositionalNotationPrinter.IDigitProvider createIntegerDigitProvider(final BigInteger value, int radix) {
            final BigInteger bigRadix = BigInteger.valueOf(radix);
            return new PositionalNotationPrinter.IDigitProvider(){
                private BigInteger remainder;
                {
                    this.remainder = value;
                }

                @Override
                public int getNextDigit() {
                    BigInteger[] divideAndRemainder = this.remainder.divideAndRemainder(bigRadix);
                    this.remainder = divideAndRemainder[0];
                    return divideAndRemainder[1].intValue();
                }

                @Override
                public boolean hasNextDigit() {
                    return !Helper.checkIsZero(this.remainder);
                }
            };
        }

        @Override
        protected PositionalNotationPrinter.IDigitProvider createFractionalDigitProvider(BigInteger value, int radix) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected boolean isNegative(BigInteger value) {
            return value.signum() < 0;
        }

        @Override
        protected BigInteger negate(BigInteger value) {
            return value.negate();
        }

        @Override
        protected boolean isZero(BigInteger value) {
            return Helper.checkIsZero(value);
        }

        private static boolean checkIsZero(BigInteger value) {
            return value.equals(BigInteger.ZERO);
        }
    }
}

