/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import java.util.Collection;
import openmods.calc.Frame;
import openmods.calc.SymbolMap;
import openmods.calc.types.multi.Cons;
import openmods.calc.types.multi.IBindPattern;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class BindPatternTranslator {
    public static IBindPattern createPatternForVarName(String var) {
        return var.equals("_") ? PatternAny.INSTANCE : new PatternBindName(var);
    }

    public IBindPattern translatePattern(TypedValue value) {
        if (value.is(IBindPatternProvider.class)) {
            IBindPatternProvider p = value.as(IBindPatternProvider.class);
            return p.getPattern(this);
        }
        if (value.is(Cons.class)) {
            Cons pair = value.as(Cons.class);
            IBindPattern carPattern = this.translatePattern(pair.car);
            IBindPattern cdrPattern = this.translatePattern(pair.cdr);
            return new PatternMatchCons(carPattern, cdrPattern);
        }
        return new PatternMatchConst(value);
    }

    public static void registerType(TypeDomain domain) {
        domain.registerType(IBindPatternProvider.class, "patternPlaceholder");
    }

    private static class PatternMatchCons
    implements IBindPattern {
        private final IBindPattern carMatcher;
        private final IBindPattern cdrMatcher;

        public PatternMatchCons(IBindPattern carMatcher, IBindPattern cdrMatcher) {
            this.carMatcher = carMatcher;
            this.cdrMatcher = cdrMatcher;
        }

        @Override
        public boolean match(Frame<TypedValue> env, SymbolMap<TypedValue> output, TypedValue value) {
            if (!value.is(Cons.class)) {
                return false;
            }
            Cons pair = value.as(Cons.class);
            return this.carMatcher.match(env, output, pair.car) && this.cdrMatcher.match(env, output, pair.cdr);
        }

        @Override
        public void listBoundVars(Collection<String> output) {
            this.carMatcher.listBoundVars(output);
            this.cdrMatcher.listBoundVars(output);
        }

        @Override
        public String serialize() {
            return this.carMatcher.serialize() + ":" + this.cdrMatcher.serialize();
        }
    }

    private static class PatternMatchConst
    implements IBindPattern {
        private final TypedValue expected;

        public PatternMatchConst(TypedValue expected) {
            this.expected = expected;
        }

        @Override
        public boolean match(Frame<TypedValue> env, SymbolMap<TypedValue> output, TypedValue value) {
            return value.equals(this.expected);
        }

        @Override
        public void listBoundVars(Collection<String> output) {
        }

        @Override
        public String serialize() {
            return this.expected.toString();
        }
    }

    private static class PatternBindName
    implements IBindPattern {
        private final String name;

        public PatternBindName(String name) {
            this.name = name;
        }

        @Override
        public boolean match(Frame<TypedValue> env, SymbolMap<TypedValue> output, TypedValue value) {
            output.put(this.name, value);
            return true;
        }

        @Override
        public void listBoundVars(Collection<String> output) {
            output.add(this.name);
        }

        @Override
        public String serialize() {
            return this.name;
        }
    }

    private static class PatternAny
    implements IBindPattern {
        public static final PatternAny INSTANCE = new PatternAny();

        private PatternAny() {
        }

        @Override
        public boolean match(Frame<TypedValue> env, SymbolMap<TypedValue> output, TypedValue value) {
            return true;
        }

        @Override
        public void listBoundVars(Collection<String> output) {
        }

        @Override
        public String serialize() {
            return "_";
        }
    }

    public static interface IBindPatternProvider {
        public IBindPattern getPattern(BindPatternTranslator var1);
    }
}

