/*
 * Decompiled with CFR 0.152.
 */
package openmods.datastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import openmods.datastore.DataStore;
import openmods.datastore.DataStoreBuilder;
import openmods.datastore.DataStoreKey;
import openmods.datastore.DataStoreReader;
import openmods.datastore.DataStoreWrapper;
import openmods.datastore.DataStoreWriter;
import openmods.datastore.IDataVisitor;

public class DataStoreManager {
    private final BiMap<DataStoreKey<?, ?>, String> dataStoreKeys = HashBiMap.create();
    protected final Map<DataStoreKey<?, ?>, DataStoreWrapper<?, ?>> dataStoreMeta = Maps.newHashMap();

    private <K, V> void checkKeyExists(DataStoreKey<K, V> key) {
        if (!this.dataStoreKeys.containsKey(key)) {
            throw new UnknownKey(key);
        }
    }

    protected <K, V> DataStoreWrapper<K, V> getDataStoreMeta(DataStoreKey<K, V> key) {
        this.checkKeyExists(key);
        DataStoreWrapper<?, ?> meta = this.dataStoreMeta.get(key);
        if (meta == null) {
            throw new UnknownKey(key);
        }
        return meta;
    }

    protected <V, K> DataStoreWrapper<K, V> getDataStoreMeta(String id) {
        DataStoreKey key = (DataStoreKey)this.dataStoreKeys.inverse().get((Object)id);
        if (key == null) {
            throw new UnknownKeyId(id);
        }
        return this.getDataStoreMeta(key);
    }

    public <K, V> DataStore<K, V> getLocalDataStore(DataStoreKey<K, V> key) {
        return this.getDataStoreMeta(key).localData();
    }

    public <K, V> DataStore<K, V> getActiveDataStore(DataStoreKey<K, V> key) {
        return this.getDataStoreMeta(key).activeData();
    }

    public <K, V> DataStoreReader<K, V> createDataStoreReader(String id) {
        return this.getDataStoreMeta(id).createReader();
    }

    public <K, V> DataStoreWriter<K, V> createDataStoreWriter(DataStoreKey<K, V> key) {
        return this.getDataStoreMeta(key).createWriter();
    }

    public <K, V> void addCallback(DataStoreKey<K, V> key, IDataVisitor<K, V> visitor) {
        this.getDataStoreMeta(key).addVisitor(visitor);
    }

    public void activateLocalData() {
        for (DataStoreWrapper<?, ?> meta : this.dataStoreMeta.values()) {
            meta.activateLocalData();
        }
    }

    public <K, V> DataStoreBuilder<K, V> createDataStore(String id, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        DataStoreKey key = new DataStoreKey(id);
        String prev = (String)this.dataStoreKeys.put(key, (Object)id);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Overwriting key with name %s", (Object[])new Object[]{id});
        return new DataStoreBuilder<K, V>(this, key, keyClass, valueClass);
    }

    <K, V> void register(DataStoreKey<K, V> key, DataStoreWrapper<K, V> meta) {
        this.checkKeyExists(key);
        DataStoreWrapper<K, V> prev = this.dataStoreMeta.put(key, meta);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Overwriting wrapper for key %s", (Object[])new Object[]{key});
    }

    public void validate() {
        Sets.SetView missing = Sets.difference((Set)this.dataStoreKeys.keySet(), this.dataStoreMeta.keySet());
        Preconditions.checkState((boolean)missing.isEmpty(), (String)"Keys [%s] were registered, but are not associated with any data", (Object[])new Object[]{missing});
    }

    public static class UnknownKeyId
    extends RuntimeException {
        private static final long serialVersionUID = -997878954285130254L;

        public UnknownKeyId(String id) {
            super(id);
        }
    }

    public static class UnknownKey
    extends RuntimeException {
        private static final long serialVersionUID = -1956682447443082464L;

        public UnknownKey(DataStoreKey<?, ?> key) {
            super(key.toString());
        }
    }
}

