/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import openmods.datastore.IDataVisitor;
import openmods.network.rpc.MethodParamsCodec;

public class MethodIdRegistry
implements IDataVisitor<String, Integer> {
    private final Set<Class<?>> registeredInterfaces = Sets.newHashSet();
    private final BiMap<Method, Integer> methodIds = HashBiMap.create();
    private Map<String, Method> methods = ImmutableMap.of();

    public boolean isClassRegistered(Class<?> cls) {
        return this.registeredInterfaces.contains(cls);
    }

    public int methodToId(Method method) {
        Integer id = (Integer)this.methodIds.get((Object)method);
        Preconditions.checkNotNull((Object)id, (String)"Method %s is ignored or not registered", (Object[])new Object[]{method});
        return id;
    }

    public Method idToMethod(int id) {
        Method method = (Method)this.methodIds.inverse().get((Object)id);
        Preconditions.checkNotNull((Object)method, (String)"Unregistered method id %s", (Object[])new Object[]{id});
        return method;
    }

    @Override
    public void begin(int size) {
        this.registeredInterfaces.clear();
        this.methodIds.clear();
    }

    @Override
    public void entry(String methodDesc, Integer id) {
        Method method = this.methods.get(methodDesc);
        if (method == null) {
            throw new IllegalArgumentException("Can't find method " + methodDesc);
        }
        MethodParamsCodec.create(method).validate();
        this.methodIds.put((Object)method, (Object)id);
        Class<?> declaringClass = method.getDeclaringClass();
        this.registeredInterfaces.add(declaringClass);
    }

    @Override
    public void end() {
    }

    public void addMethods(Map<String, Method> methods) {
        this.methods = ImmutableMap.copyOf(methods);
    }
}

