/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import openmods.Log;
import openmods.reflection.ReflectionHelper;

public class SafeClassLoad {
    public final String clsName;
    private Class<?> loaded;

    public SafeClassLoad(String clsName) {
        this.clsName = clsName;
    }

    public static SafeClassLoad create(String clsName) {
        return new SafeClassLoad(clsName);
    }

    public void load() {
        if (this.loaded == null) {
            this.loaded = ReflectionHelper.getClass(this.clsName);
        }
    }

    public Class<?> get() {
        this.load();
        return this.loaded;
    }

    public boolean tryLoad() {
        return this.tryLoad(true);
    }

    public boolean tryLoad(boolean silent) {
        try {
            this.load();
            return true;
        }
        catch (Throwable t) {
            if (!silent) {
                Log.warn(t, "Loading class %s failed", this.clsName);
            }
            return false;
        }
    }

    public String toString() {
        return "delayed " + this.clsName;
    }
}

