/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import openmods.renderer.DisposableDynamicTexture;
import openmods.utils.ByteUtils;

public class DynamicTextureAtlas {
    private final List<AtlasCell> cells = Lists.newArrayList();
    public final int cellSize;
    private final TextureManager manager;
    private final DisposableDynamicTexture textureWrapper;
    private final ResourceLocation textureLocation;

    public DynamicTextureAtlas(TextureManager manager, int cellSize) {
        Preconditions.checkArgument((boolean)ByteUtils.isPowerOfTwo(cellSize), (Object)"NO POWER!");
        this.manager = manager;
        this.cellSize = cellSize;
        this.textureWrapper = new DisposableDynamicTexture();
        this.textureLocation = this.textureWrapper.register(manager, "dyn-atlas");
    }

    public void bind() {
        this.manager.func_110577_a(this.textureLocation);
    }

    public AtlasCell allocateCell() {
        AtlasCell cell = new AtlasCell();
        this.cells.add(cell);
        return cell;
    }

    public void clearCells() {
        this.cells.clear();
    }

    public void compile() {
        int count = this.cells.size();
        Preconditions.checkState((count > 0 ? 1 : 0) != 0, (Object)"No cells added");
        int side = (int)Math.ceil(Math.sqrt(count));
        int width = ByteUtils.nextPowerOf2(side);
        int area = width * width;
        int height = count <= area / 2 ? width / 2 : width;
        this.textureWrapper.resize(width * this.cellSize, height * this.cellSize);
        int[] buffer = this.textureWrapper.allocate();
        int pixelsPerLine = width * this.cellSize;
        int pixelsPerCellRow = pixelsPerLine * this.cellSize;
        float cellU = 1.0f / (float)width;
        float cellV = 1.0f / (float)height;
        for (int cell = 0; cell < count; ++cell) {
            int cellX = cell % width;
            int cellY = cell / width;
            AtlasCell cellData = this.cells.get(cell);
            int cellStart = cellY * pixelsPerCellRow + cellX * this.cellSize;
            for (int row = 0; row < this.cellSize; ++row) {
                int dstPos = cellStart + row * pixelsPerLine;
                int srcPos = row * this.cellSize;
                System.arraycopy(cellData.pixels, srcPos, buffer, dstPos, 64);
            }
            AtlasCell.access$002(cellData, null);
            cellData.minU = (float)cellX / (float)width;
            cellData.minV = (float)cellY / (float)height;
            cellData.maxU = cellData.minU + cellU;
            cellData.maxV = cellData.minV + cellV;
        }
        this.textureWrapper.updateAndDeallocate();
    }

    public class AtlasCell {
        private int[] pixels;
        public float minU;
        public float minV;
        public float maxU;
        public float maxV;

        public void setPixels(int[] pixels) {
            this.pixels = pixels;
        }

        static /* synthetic */ int[] access$002(AtlasCell x0, int[] x1) {
            x0.pixels = x1;
            return x1;
        }
    }
}

