/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer.shaders;

import java.nio.ByteBuffer;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;

public class BufferHelper {
    public static IBufferMethods methods;

    static void initialize() {
        ContextCapabilities caps = GLContext.getCapabilities();
        if (GLBufferMethods.isSupported(caps)) {
            methods = new GLBufferMethods();
        } else if (ARBBufferMethods.isSupported(caps)) {
            methods = new ARBBufferMethods();
        }
    }

    public static boolean isSupported() {
        return methods != null;
    }

    public static IBufferMethods methods() {
        return methods;
    }

    static {
        BufferHelper.initialize();
    }

    private static class ARBBufferMethods
    implements IBufferMethods {
        private ARBBufferMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.OpenGL15;
        }

        @Override
        public int glGenBuffers() {
            return ARBBufferObject.glGenBuffersARB();
        }

        @Override
        public void glBindBuffer(int target, int buffer) {
            ARBBufferObject.glBindBufferARB((int)target, (int)buffer);
        }

        @Override
        public void glBufferData(int target, ByteBuffer data, int usage) {
            ARBBufferObject.glBufferDataARB((int)target, (ByteBuffer)data, (int)usage);
        }

        @Override
        public void glDeleteBuffers(int buffer) {
            ARBBufferObject.glDeleteBuffersARB((int)buffer);
        }
    }

    private static class GLBufferMethods
    implements IBufferMethods {
        private GLBufferMethods() {
        }

        public static boolean isSupported(ContextCapabilities caps) {
            return caps.OpenGL15;
        }

        @Override
        public int glGenBuffers() {
            return GL15.glGenBuffers();
        }

        @Override
        public void glBindBuffer(int target, int buffer) {
            GL15.glBindBuffer((int)target, (int)buffer);
        }

        @Override
        public void glBufferData(int target, ByteBuffer data, int usage) {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        }

        @Override
        public void glDeleteBuffers(int buffer) {
            GL15.glDeleteBuffers((int)buffer);
        }
    }

    public static interface IBufferMethods {
        public int glGenBuffers();

        public void glBindBuffer(int var1, int var2);

        public void glBufferData(int var1, ByteBuffer var2, int var3);

        public void glDeleteBuffers(int var1);
    }
}

