/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.providers;

import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;
import openmods.reflection.TypeUtils;
import openmods.serializable.IGenericSerializerProvider;
import openmods.serializable.providers.NullableCollectionSerializer;
import openmods.utils.io.IStreamSerializer;

public class SetSerializerProvider
implements IGenericSerializerProvider {
    @Override
    public IStreamSerializer<?> getSerializer(Type type) {
        TypeToken typeToken = TypeToken.of((Type)type);
        if (TypeUtils.SET_TOKEN.isAssignableFrom(typeToken)) {
            TypeToken componentType = typeToken.resolveType(TypeUtils.SET_VALUE_PARAM);
            return this.createSetSerializer(componentType);
        }
        return null;
    }

    protected IStreamSerializer<?> createSetSerializer(TypeToken<?> componentType) {
        final IStreamSerializer<Object[]> arraySerializer = NullableCollectionSerializer.createObjectArraySerializer(componentType);
        return new IStreamSerializer<Set<?>>(){

            @Override
            public Set<?> readFromStream(DataInput input) throws IOException {
                Object[] values = (Object[])arraySerializer.readFromStream(input);
                return Sets.newHashSet((Object[])values);
            }

            @Override
            public void writeToStream(Set<?> o, DataOutput output) throws IOException {
                Object[] tmp = new Object[o.size()];
                arraySerializer.writeToStream(o.toArray(tmp), output);
            }
        };
    }
}

