/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraft.world.World;
import openmods.OpenMods;
import openmods.sync.ISyncMapProvider;
import openmods.sync.SyncMap;

@ChannelHandler.Sharable
public class InboundSyncHandler
extends SimpleChannelInboundHandler<FMLProxyPacket> {
    protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
        World world = OpenMods.proxy.getClientWorld();
        ByteBuf payload = msg.payload();
        DataInputStream input = new DataInputStream((InputStream)new ByteBufInputStream(payload));
        ISyncMapProvider provider = SyncMap.findSyncMap(world, input);
        try {
            if (provider != null) {
                provider.getSyncMap().readFromStream(input);
            }
        }
        catch (Throwable e) {
            throw new SyncException(e, provider);
        }
    }

    public static class SyncException
    extends RuntimeException {
        private static final long serialVersionUID = 2585053869917082095L;

        public SyncException(Throwable cause, ISyncMapProvider provider) {
            super(String.format("Failed to sync %s (%s)", provider, provider.getClass()), cause);
        }
    }
}

