/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.newtypes;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataAmountRate;
import mcp.mobius.opis.data.holders.newtypes.DataByteRate;
import mcp.mobius.opis.data.holders.newtypes.DataByteSize;
import net.minecraft.network.Packet;

public class DataPacket
implements ISerializable {
    public int id;
    public DataByteSize size;
    public DataByteRate rate;
    public DataAmountRate amount;
    public CachedString type;

    public DataPacket() {
    }

    public DataPacket(Packet packet) {
        this.type = new CachedString(packet.getClass().getSimpleName());
        this.size = new DataByteSize(0L);
        this.rate = new DataByteRate(0L, 5);
        this.amount = new DataAmountRate(0L, 5);
    }

    public DataPacket fill(Packet packet, int pktsize) {
        Comparable<DataByteSize> comparable = this.size;
        comparable.size = comparable.size + (long)pktsize;
        comparable = this.rate;
        ((DataByteRate)comparable).size = ((DataByteRate)comparable).size + (long)pktsize;
        comparable = this.amount;
        ((DataAmountRate)comparable).size = ((DataAmountRate)comparable).size + 1L;
        return this;
    }

    public void startInterval() {
        this.rate.reset();
        this.amount.reset();
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        this.size.writeToStream(stream);
        this.rate.writeToStream(stream);
        this.amount.writeToStream(stream);
        this.type.writeToStream(stream);
    }

    public static DataPacket readFromStream(ByteArrayDataInput stream) {
        DataPacket retVal = new DataPacket();
        retVal.size = DataByteSize.readFromStream(stream);
        retVal.rate = DataByteRate.readFromStream(stream);
        retVal.amount = DataAmountRate.readFromStream(stream);
        retVal.type = CachedString.readFromStream(stream);
        return retVal;
    }
}

