/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import gcewing.projectblue.BundledUtils;
import gcewing.projectblue.ControlPanelMaterial;
import gcewing.projectblue.ControlPanelRenderer;
import gcewing.projectblue.FaceUtils;
import gcewing.projectblue.Matrix3;
import gcewing.projectblue.PBFacePart;
import gcewing.projectblue.ProjectBlue;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Vector3;
import java.util.ArrayList;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.ItemScrewdriver;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ControlPanelPart
extends PBFacePart
implements IConnectable,
IBundledEmitter {
    static final int buttonDownTime = 20;
    static Cuboid6[] bounds = ControlPanelPart.newBounds(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    static Matrix3 surfaceMountRotation = Matrix3.rotZ(180.0);
    public int mounting;
    public int connectionMask;
    byte[] controlTypes = new byte[16];
    byte[] controlStates = new byte[16];
    byte[] controlMetadata = new byte[16];
    public String[][] labels = new String[16][2];
    public ControlPanelMaterial base;
    long[] releaseTime = new long[16];
    byte[] signal = new byte[16];
    static long lastActivateTime = 0L;

    public ControlPanelPart() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.labels[i][j] = "";
            }
        }
    }

    public ControlPanelPart(String material, int side) {
        this(material, side, null);
    }

    public ControlPanelPart(String material, int side, NBTTagCompound nbt) {
        this(ControlPanelMaterial.forName(material), side, nbt);
    }

    public ControlPanelPart(ControlPanelMaterial base, int side, NBTTagCompound nbt) {
        this();
        this.base = base;
        this.side = side;
        this.mounting = 1;
        if (nbt != null) {
            this.loadControls(nbt);
        }
    }

    @Override
    public Cuboid6[] getBoundsArray() {
        return bounds;
    }

    void setMaterial(String material) {
        this.base = ControlPanelMaterial.forName(material);
    }

    public ControlType getControlType(int i) {
        return ControlType.values[this.controlTypes[i]];
    }

    public void setControlType(int i, ControlType type) {
        this.controlTypes[i] = (byte)type.ordinal();
    }

    public int getControlState(int i) {
        return this.controlStates[i];
    }

    public void setControlState(int i, int state) {
        this.controlStates[i] = (byte)state;
    }

    public int getControlMeta(int i) {
        return this.controlMetadata[i] & 0xFF;
    }

    public void setControlMeta(int i, int meta) {
        this.controlMetadata[i] = (byte)meta;
    }

    public void setFlushMounting() {
        this.mounting = 0;
    }

    public void setSurfaceMounting() {
        this.mounting = 1;
    }

    @Override
    public String getType() {
        return "pb_controlpanel";
    }

    @Override
    public Cuboid6 getBounds() {
        return bounds[this.side];
    }

    @Override
    public void writeDesc(MCDataOutput data) {
        super.writeDesc(data);
        data.writeString(this.base.name);
        data.writeByte(this.mounting);
        for (int i = 0; i < 16; ++i) {
            data.writeByte((int)this.controlTypes[i]);
            data.writeByte((int)this.controlStates[i]);
            data.writeByte((int)this.controlMetadata[i]);
            for (int j = 0; j < 2; ++j) {
                data.writeString(this.labels[i][j]);
            }
        }
    }

    @Override
    public void readDesc(MCDataInput data) {
        super.readDesc(data);
        String material = data.readString();
        if (this.base == null) {
            this.setMaterial(material);
        }
        this.mounting = data.readByte();
        for (int i = 0; i < 16; ++i) {
            this.controlTypes[i] = data.readByte();
            this.controlStates[i] = data.readByte();
            this.controlMetadata[i] = data.readByte();
            for (int j = 0; j < 2; ++j) {
                this.labels[i][j] = data.readString();
            }
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74778_a("material", this.base.name);
        nbt.func_74768_a("mounting", this.mounting);
        nbt.func_74768_a("connectionMask", this.connectionMask);
        this.saveControls(nbt);
        nbt.func_74773_a("controlStates", this.controlStates);
    }

    public void saveControls(NBTTagCompound nbt) {
        nbt.func_74773_a("controlTypes", this.controlTypes);
        nbt.func_74773_a("controlMetadata", this.controlMetadata);
        NBTTagList nbtLabels = new NBTTagList();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2; ++j) {
                nbtLabels.func_74742_a((NBTBase)new NBTTagString(this.labels[i][j]));
            }
        }
        nbt.func_74782_a("labels", (NBTBase)nbtLabels);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("material")) {
            this.setMaterial(nbt.func_74779_i("material"));
        } else {
            this.setMaterial("tile.wood");
        }
        this.mounting = nbt.func_74762_e("mounting");
        this.connectionMask = nbt.func_74764_b("connectionMask") ? nbt.func_74762_e("connectionMask") : 3;
        this.loadControls(nbt);
        if (nbt.func_74764_b("controlStates")) {
            this.controlStates = nbt.func_74770_j("controlStates");
        }
    }

    public void loadControls(NBTTagCompound nbt) {
        if (nbt.func_74764_b("controlTypes")) {
            this.controlTypes = nbt.func_74770_j("controlTypes");
        }
        if (nbt.func_74764_b("controlMetadata")) {
            this.controlMetadata = nbt.func_74770_j("controlMetadata");
        }
        if (nbt.func_74764_b("labels")) {
            NBTTagList nbtLabels = nbt.func_150295_c("labels", 8);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 2; ++j) {
                    int k = i * 2 + j;
                    this.labels[i][j] = nbtLabels.func_150307_f(k);
                }
            }
        }
    }

    @Override
    public boolean renderStatic(codechicken.lib.vec.Vector3 pos, int pass) {
        if (pass == 0) {
            ControlPanelRenderer.instance.renderStaticInWorld(this, pos.x, pos.y, pos.z);
        }
        return false;
    }

    @Override
    public void renderDynamic(codechicken.lib.vec.Vector3 pos, float frame, int pass) {
        if (pass == 0) {
            ControlPanelRenderer.instance.renderDynamicInWorld(this, pos.x, pos.y, pos.z, frame);
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.updateInputs();
    }

    public void onNeighborChanged() {
        this.updateInputs();
    }

    void updateInputs() {
        if (!this.world().field_72995_K) {
            this.getInputs();
            this.tile().func_70296_d();
            this.sendDescUpdate();
        }
    }

    void getInputs() {
        byte[] sig = BundledUtils.getAllSignals(this, this.side, this.connectionMask);
        for (int i = 0; i <= 15; ++i) {
            switch (this.getControlType(i)) {
                case LAMP: {
                    this.setControlState(i, sig[i] != 0 ? 1 : 0);
                }
            }
        }
    }

    public void click(EntityPlayer player, MovingObjectPosition hit, ItemStack stack) {
        if (!this.world().field_72995_K && player.func_70093_af() && stack != null && stack.func_77973_b() instanceof ItemScrewdriver) {
            this.harvest(hit, player);
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack stack) {
        long time;
        if (!this.world().field_72995_K && (time = this.world().func_82737_E()) != lastActivateTime) {
            lastActivateTime = time;
            Trans3 t = this.localToGlobalTransformation(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d);
            Vector3 p = t.ip(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c);
            int i = (int)Math.floor((p.z + 0.5) * 4.0);
            int j = (int)Math.floor((-p.x + 0.5) * 4.0);
            if (i >= 0 && i <= 3 && j >= 0 && j <= 3) {
                this.activateCell(i * 4 + j, player, stack);
            }
        }
        return true;
    }

    void activateCell(int i, EntityPlayer player, ItemStack stack) {
        System.out.printf("ControlPanelPart.activateCell: %s containing %s with %s\n", new Object[]{i, this.getControlType(i), stack});
        if (stack != null) {
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            NBTTagCompound nbt = stack.func_77978_p();
            if (item instanceof ItemScrewdriver) {
                if (player.func_70093_af()) {
                    this.changeMounting();
                } else if (this.getControlType(i) != ControlType.NONE) {
                    this.removeControl(i, player);
                } else {
                    this.changeRotation();
                }
                return;
            }
            if (item == Items.field_151044_h && meta == 1) {
                this.editText(i, player);
                return;
            }
            if (this.getControlType(i) == ControlType.NONE) {
                if (item == ProjectBlue.miniatureLever) {
                    this.placeControl(i, ControlType.LEVER, player, meta, stack);
                    return;
                }
                if (item == ProjectBlue.miniatureButton) {
                    this.placeControl(i, ControlType.BUTTON, player, meta, stack);
                    return;
                }
                if (item == ProjectBlue.miniatureLamp) {
                    this.placeControl(i, ControlType.LAMP, player, meta, stack);
                    return;
                }
                if (item == ProjectBlue.miniatureCover && nbt.func_74779_i("mat").equals(this.base.name)) {
                    this.placeControl(i, ControlType.BLANK, player, 0, stack);
                    return;
                }
            }
        }
        this.activateControl(i);
    }

    void placeControl(int i, ControlType type, EntityPlayer player, int meta, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        this.setControlType(i, type);
        this.setControlMeta(i, meta);
        this.getInputs();
        this.changed();
    }

    void removeControl(int i, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.drop(this.stackForControl(i));
        }
        this.setControlType(i, ControlType.NONE);
        this.setControlState(i, 0);
        this.changed();
    }

    void changeMounting() {
        this.mounting ^= 1;
        this.changed();
    }

    void changeRotation() {
        this.rot = this.rot + 1 & 3;
        this.changed();
    }

    void editText(int i, EntityPlayer player) {
        ProjectBlue.channel.sendEditControlPanelText(player, this, i);
    }

    public void harvest(MovingObjectPosition hit, EntityPlayer player) {
        this.tile().dropItems(this.getDrops());
        this.tile().remPart((TMultiPart)this);
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = this.base.newStack();
        this.saveControls(stack.func_77978_p());
        list.add(stack);
        return list;
    }

    ItemStack stackForControl(int i) {
        ItemStack stack = null;
        NBTTagCompound nbt = null;
        int meta = this.getControlMeta(i);
        switch (this.getControlType(i)) {
            case LEVER: {
                stack = new ItemStack(ProjectBlue.miniatureLever, 1, meta);
                break;
            }
            case BUTTON: {
                stack = new ItemStack(ProjectBlue.miniatureButton, 1, meta);
                break;
            }
            case LAMP: {
                stack = new ItemStack(ProjectBlue.miniatureLamp, 1, meta);
                break;
            }
            case BLANK: {
                stack = new ItemStack(ProjectBlue.miniatureCover);
                nbt = new NBTTagCompound();
                nbt.func_74778_a("mat", this.base.name);
            }
        }
        if (stack != null) {
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    void drop(ItemStack stack) {
        if (stack != null) {
            Trans3 t = this.localToGlobalTransformation();
            Vector3 p = t.p(0.0, -0.6, 0.0);
            World world = this.world();
            EntityItem item = new EntityItem(world, p.x, p.y, p.z, stack);
            item.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
            item.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
            item.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
            item.field_145804_b = 10;
            world.func_72838_d((Entity)item);
        }
    }

    void activateControl(int i) {
        switch (this.getControlType(i)) {
            case LEVER: {
                this.toggleLever(i);
                break;
            }
            case BUTTON: {
                this.pressButton(i);
            }
        }
    }

    void toggleLever(int i) {
        int state = this.getControlState(i) ^ 1;
        this.setControlState(i, state);
        this.playClick(state > 0 ? 0.6 : 0.5);
        this.changed();
    }

    void pressButton(int i) {
        this.setControlState(i, 1);
        this.releaseTime[i] = this.world().func_82737_E() + 20L;
        this.scheduleTick(20);
        this.playClick(0.6);
        this.changed();
    }

    public void scheduledTick() {
        long t_now = this.world().func_82737_E();
        long t_next = -1L;
        boolean release_occurred = false;
        block3: for (int i = 0; i < 16; ++i) {
            switch (this.getControlType(i)) {
                case BUTTON: {
                    if (this.getControlState(i) <= 0) continue block3;
                    if (t_now >= this.releaseTime[i]) {
                        this.setControlState(i, 0);
                        release_occurred = true;
                        continue block3;
                    }
                    if (t_next >= 0L && t_next <= this.releaseTime[i]) continue block3;
                    t_next = this.releaseTime[i];
                }
            }
        }
        if (t_next >= 0L) {
            this.scheduleTick((int)(t_next - t_now));
        }
        if (release_occurred) {
            this.playClick(0.5);
            this.changed();
        }
    }

    void playClick(double pitch) {
        this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "random.click", 0.3f, (float)pitch);
    }

    public void setLabel(int cell, int line, String text) {
        this.labels[cell][line] = text;
        this.changed();
    }

    @Override
    public void changed() {
        FaceUtils.notifyAllNeighbors(this, this.side);
        super.changed();
    }

    public Trans3 localToGlobalTransformation() {
        return this.localToGlobalTransformation(this.x(), this.y(), this.z());
    }

    public Trans3 localToGlobalTransformation(double x, double y, double z) {
        Trans3 t = new Trans3(x + 0.5, y + 0.5, z + 0.5).side(this.side).turn(this.rot).translate(0.0, -0.4375, 0.0);
        if (this.mounting == 1) {
            t = t.rotate(surfaceMountRotation);
        }
        return t;
    }

    public boolean connectStraight(IConnectable part, int r, int edgeRot) {
        return this.connectTo(part, r);
    }

    public boolean connectInternal(IConnectable part, int r) {
        return this.connectTo(part, r);
    }

    public boolean connectCorner(IConnectable part, int r, int edgeRot) {
        return this.connectTo(part, r);
    }

    public boolean canConnectCorner(int r) {
        return true;
    }

    boolean connectTo(IConnectable part, int r) {
        if (!(part instanceof ControlPanelPart)) {
            this.connectionMask |= 1 << r;
            this.markDirty();
            return true;
        }
        return false;
    }

    public byte[] getBundledSignal(int side) {
        block3: for (int i = 0; i < 16; ++i) {
            switch (this.getControlType(i)) {
                case LEVER: 
                case BUTTON: {
                    this.signal[i] = (byte)(255 * this.getControlState(i));
                    continue block3;
                }
                default: {
                    this.signal[i] = 0;
                }
            }
        }
        return this.signal;
    }

    public static enum ControlType {
        NONE,
        BLANK,
        LEVER,
        BUTTON,
        LAMP;

        public static ControlType[] values;

        static {
            values = ControlType.values();
        }
    }

    public static class Factory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String name, boolean client) {
            ControlPanelPart part = new ControlPanelPart();
            return part;
        }
    }
}

