/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.util.effects;

import cpw.mods.fml.client.FMLClientHandler;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.core.items.IToolGoggles;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.client.core.AuraKeyHandler;
import mods.railcraft.client.particles.EntityChimneyFX;
import mods.railcraft.client.particles.EntityChunkLoaderFX;
import mods.railcraft.client.particles.EntityFireSparkFX;
import mods.railcraft.client.particles.EntityForceSpawnFX;
import mods.railcraft.client.particles.EntityHeatTrailFX;
import mods.railcraft.client.particles.EntitySteamFX;
import mods.railcraft.client.particles.EntityTuningFX;
import mods.railcraft.client.render.RenderTESRSignals;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.util.effects.CommonEffectProxy;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.PacketEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ClientEffectProxy
extends CommonEffectProxy {
    public static final short TELEPORT_PARTICLES = 64;
    public static final short TRACKING_DISTANCE = 1024;

    public ClientEffectProxy() {
        SignalTools.effectManager = this;
    }

    private void doTeleport(DataInputStream data) throws IOException {
        double startX = data.readDouble();
        double startY = data.readDouble();
        double startZ = data.readDouble();
        double destX = data.readDouble();
        double destY = data.readDouble();
        double destZ = data.readDouble();
        for (int i = 0; i < 64; ++i) {
            double travel = (double)i / 63.0;
            float vX = (rand.nextFloat() - 0.5f) * 0.2f;
            float vY = (rand.nextFloat() - 0.5f) * 0.2f;
            float vZ = (rand.nextFloat() - 0.5f) * 0.2f;
            double pX = startX + (destX - startX) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pY = startY + (destY - startY) * travel + (rand.nextDouble() - 0.5) * 2.0;
            double pZ = startZ + (destZ - startZ) * travel + (rand.nextDouble() - 0.5) * 2.0;
            Game.getWorld().func_72869_a("portal", pX, pY, pZ, (double)vX, (double)vY, (double)vZ);
        }
    }

    public void doForceSpawn(DataInputStream data) throws IOException {
        if (!this.shouldSpawnParticle(true)) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        this.spawnParticle(new EntityForceSpawnFX(Game.getWorld(), (double)x + 0.1, y, (double)z + 0.1, vx, vy, vz));
        this.spawnParticle(new EntityForceSpawnFX(Game.getWorld(), (double)x + 0.9, y, (double)z + 0.1, vx, vy, vz));
        this.spawnParticle(new EntityForceSpawnFX(Game.getWorld(), (double)x + 0.1, y, (double)z + 0.9, vx, vy, vz));
        this.spawnParticle(new EntityForceSpawnFX(Game.getWorld(), (double)x + 0.9, y, (double)z + 0.9, vx, vy, vz));
    }

    @Override
    public boolean isTuningAuraActive() {
        return this.isGoggleAuraActive(ItemGoggles.GoggleAura.TUNING) || this.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING);
    }

    @Override
    public boolean isGoggleAuraActive(ItemGoggles.GoggleAura aura) {
        ItemStack helm = Minecraft.func_71410_x().field_71439_g.func_82169_q(MiscTools.ArmorSlots.HELM.ordinal());
        if (helm != null && helm.func_77973_b() instanceof IToolGoggles) {
            return ((IToolGoggles)helm.func_77973_b()).getCurrentAura(helm) == aura;
        }
        return AuraKeyHandler.isAuraEnabled(aura);
    }

    @Override
    public void tuningEffect(TileEntity start, TileEntity dest) {
        if (!this.shouldSpawnParticle(false)) {
            return;
        }
        if (rand.nextInt(2) == 0) {
            double px = (double)start.field_145851_c + 0.5 + rand.nextGaussian() * 0.1;
            double py = (double)start.field_145848_d + 0.5 + rand.nextGaussian() * 0.1;
            double pz = (double)start.field_145849_e + 0.5 + rand.nextGaussian() * 0.1;
            RenderTESRSignals.ColorProfile colorProfile = RenderTESRSignals.ColorProfile.RAINBOW;
            if (this.isGoggleAuraActive(ItemGoggles.GoggleAura.SIGNALLING)) {
                colorProfile = RenderTESRSignals.ColorProfile.ASPECT;
            }
            int color = colorProfile.getColor(start, new WorldCoordinate(start), new WorldCoordinate(dest));
            EntityTuningFX particle = new EntityTuningFX(start.func_145831_w(), px, py, pz, EffectManager.getEffectSource(dest), color);
            this.spawnParticle(particle);
        }
    }

    @Override
    public void trailEffect(int startX, int startY, int startZ, TileEntity dest, long colorSeed) {
        if (!this.shouldSpawnParticle(false)) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70092_e((double)startX, (double)startY, (double)startZ) > 1024.0) {
            return;
        }
        if (rand.nextInt(3) == 0) {
            double px = (double)startX + 0.5 + rand.nextGaussian() * 0.1;
            double py = (double)startY + 0.5 + rand.nextGaussian() * 0.1;
            double pz = (double)startZ + 0.5 + rand.nextGaussian() * 0.1;
            EntityHeatTrailFX particle = new EntityHeatTrailFX(dest.func_145831_w(), px, py, pz, colorSeed, EffectManager.getEffectSource(dest));
            this.spawnParticle(particle);
        }
    }

    @Override
    public void fireSparkEffect(World world, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        if (!this.shouldSpawnParticle(false)) {
            return;
        }
        EntityFireSparkFX particle = new EntityFireSparkFX(world, startX, startY, startZ, endX, endY, endZ);
        this.spawnParticle(particle);
    }

    private void doFireSpark(DataInputStream data) throws IOException {
        double startX = data.readDouble();
        double startY = data.readDouble();
        double startZ = data.readDouble();
        double destX = data.readDouble();
        double destY = data.readDouble();
        double destZ = data.readDouble();
        this.fireSparkEffect((World)Minecraft.func_71410_x().field_71441_e, startX, startY, startZ, destX, destY, destZ);
    }

    @Override
    public void handleEffectPacket(DataInputStream data) throws IOException {
        byte effectId = data.readByte();
        if (effectId < 0) {
            return;
        }
        PacketEffect.Effect effect = PacketEffect.Effect.values()[effectId];
        switch (effect) {
            case TELEPORT: {
                this.doTeleport(data);
                break;
            }
            case FIRESPARK: {
                this.doFireSpark(data);
                break;
            }
            case FORCE_SPAWN: {
                this.doForceSpawn(data);
            }
        }
    }

    @Override
    public void chunkLoaderEffect(World world, Object source, Set<ChunkCoordIntPair> chunks) {
        if (!this.isGoggleAuraActive(ItemGoggles.GoggleAura.ANCHOR)) {
            return;
        }
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        if (FMLClientHandler.instance().getClient().field_71439_g.func_70092_e(es.getX(), es.getY(), es.getZ()) > 25600.0) {
            return;
        }
        for (ChunkCoordIntPair chunk : chunks) {
            int xCorner = chunk.field_77276_a * 16;
            int zCorner = chunk.field_77275_b * 16;
            double yCorner = es.getY() - 8.0;
            if (rand.nextInt(3) != 0 || !this.shouldSpawnParticle(false)) continue;
            double xParticle = (float)xCorner + rand.nextFloat() * 16.0f;
            double yParticle = yCorner + (double)(rand.nextFloat() * 16.0f);
            double zParticle = (float)zCorner + rand.nextFloat() * 16.0f;
            EntityChunkLoaderFX particle = new EntityChunkLoaderFX(world, xParticle, yParticle, zParticle, es);
            this.spawnParticle(particle);
        }
    }

    @Override
    public void steamEffect(World world, Object source, double yOffset) {
        if (!this.shouldSpawnParticle(true)) {
            return;
        }
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        double vx = rand.nextGaussian() * 0.1;
        double vy = rand.nextDouble() * 0.01;
        double vz = rand.nextGaussian() * 0.1;
        this.spawnParticle(new EntitySteamFX(world, es.getX(), es.getY() + yOffset, es.getZ(), vx, vy, vz));
    }

    @Override
    public void steamJetEffect(World world, Object source, double vecX, double vecY, double vecZ) {
        if (!this.shouldSpawnParticle(true)) {
            return;
        }
        EffectManager.IEffectSource es = EffectManager.getEffectSource(source);
        double vx = vecX + rand.nextGaussian() * 0.02;
        double vy = vecY + rand.nextGaussian() * 0.02;
        double vz = vecZ + rand.nextGaussian() * 0.02;
        EntitySteamFX fx = new EntitySteamFX(world, es.getX(), es.getY(), es.getZ(), vx, vy, vz, 1.5f);
        fx.gravity = 0.0;
        this.spawnParticle(fx);
    }

    @Override
    public void chimneyEffect(World world, double x, double y, double z) {
        if (!this.shouldSpawnParticle(false)) {
            return;
        }
        this.spawnParticle(new EntityChimneyFX(world, x, y, z));
    }

    private boolean shouldSpawnParticle(boolean canDisable) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        int particleSetting = mc.field_71474_y.field_74362_aa;
        if (!canDisable && particleSetting > 1) {
            particleSetting = 1;
        }
        if (particleSetting == 1 && MiscTools.RANDOM.nextInt(3) == 0) {
            particleSetting = 2;
        }
        return particleSetting <= 1;
    }

    @Override
    protected void spawnParticle(EntityFX particle) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        mc.field_71452_i.func_78873_a(particle);
    }
}

