/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityCartFurnace
extends EntityMinecartFurnace {
    private static final double DRAG_FACTOR = 0.99;
    private static final double PUSH_FACTOR = 0.1;

    public EntityCartFurnace(World world) {
        super(world);
    }

    public EntityCartFurnace(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.field_151143_au));
            items.add(new ItemStack(Blocks.field_150460_al));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void func_94095_a(DamageSource par1DamageSource) {
        this.func_70106_y();
        List<ItemStack> drops = this.getItemsDropped();
        if (this.func_95999_t() != null) {
            drops.get(0).func_151001_c(this.func_95999_t());
        }
        for (ItemStack item : drops) {
            this.func_70099_a(item, 0.0f);
        }
    }

    public ItemStack getCartItem() {
        ItemStack stack = new ItemStack(Items.field_151109_aJ);
        if (this.func_145818_k_()) {
            stack.func_151001_c(this.func_70005_c_());
        }
        return stack;
    }

    public double getDrag() {
        return 0.99;
    }

    public boolean func_130002_c(EntityPlayer player) {
        int burnTime;
        ItemStack stack;
        Integer fuel = (Integer)ReflectionHelper.getPrivateValue(EntityMinecartFurnace.class, (Object)((Object)this), (int)0);
        if (fuel <= 0 && (stack = player.field_71071_by.func_70448_g()) != null && (burnTime = FuelPlugin.getBurnTime(stack)) > 0) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InvTools.depleteItem(stack));
            }
            fuel = fuel + burnTime;
            ReflectionHelper.setPrivateValue(EntityMinecartFurnace.class, (Object)((Object)this), (Object)fuel, (int)0);
            this.field_94111_a = this.field_70165_t - player.field_70165_t;
            this.field_94109_b = this.field_70161_v - player.field_70161_v;
        }
        return true;
    }
}

