/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.Optional;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import java.util.List;
import mods.railcraft.api.core.items.ISafetyPants;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemMaterials;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")})
public class ItemOveralls
extends ItemArmor
implements ISafetyPants,
IHazardProtector {
    private static final ItemStack BLUE_CLOTH = new ItemStack(Blocks.field_150325_L, 1, 3);
    private static final String TEXTURE = "railcraft:textures/entities/armor/overalls.png";

    public static boolean isPlayerWearing(EntityPlayer player) {
        ItemStack pants = player.func_82169_q(MiscTools.ArmorSlots.LEGS.ordinal());
        return pants != null && pants.func_77973_b() instanceof ItemOveralls;
    }

    public ItemOveralls() {
        super(ItemMaterials.OVERALLS, 0, 2);
        this.func_77637_a(CreativePlugin.RAILCRAFT_TAB);
    }

    @Override
    public boolean blocksElectricTrackDamage(ItemStack pants) {
        return true;
    }

    @Override
    public void onShock(ItemStack pants, EntityPlayer player) {
        player.func_70062_b(MiscTools.ArmorSlots.LEGS.ordinal() + 1, InvTools.damageItem(pants, 1));
    }

    @Override
    public boolean lowersLocomotiveDamage(ItemStack pants) {
        return true;
    }

    @Override
    public void onHitLocomotive(ItemStack pants, EntityPlayer player) {
        player.func_70062_b(MiscTools.ArmorSlots.LEGS.ordinal() + 1, InvTools.damageItem(pants, 5));
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:" + MiscTools.cleanTag(this.func_77658_a()));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return TEXTURE;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return InvTools.isItemEqual(stack, BLUE_CLOTH);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        super.func_77624_a(stack, player, info, adv);
        ToolTip tip = ToolTip.buildToolTip(stack.func_77977_a() + ".tip", new String[0]);
        if (tip != null) {
            info.addAll(tip.convertToStrings());
        }
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return hazard == Hazard.ELECTRICAL && ModuleManager.isModuleLoaded(ModuleManager.Module.GREGTECH);
    }
}

