/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.AdjacentTileCache;
import mods.railcraft.common.util.misc.ITileFilter;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public final class AdjacentInventoryCache {
    private final AdjacentTileCache cache;
    private final List<IInventory> sortedInvs = new LinkedList<IInventory>();
    private final Map<ForgeDirection, IInventory> invs = new EnumMap<ForgeDirection, IInventory>(ForgeDirection.class);
    private final Comparator<IInventory> sorter;
    private final ITileFilter filter;
    private final EnumSet<ForgeDirection> changedSides = EnumSet.allOf(ForgeDirection.class);

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache) {
        this(tile, cache, null, null);
    }

    public AdjacentInventoryCache(TileEntity tile, AdjacentTileCache cache, ITileFilter filter, Comparator<IInventory> sorter) {
        this.cache = cache;
        cache.addListener(new AdjacentTileCache.ICacheListener(){

            @Override
            public void changed(ForgeDirection side) {
                AdjacentInventoryCache.this.changedSides.add(side);
            }

            @Override
            public void purge() {
                AdjacentInventoryCache.this.changedSides.addAll(EnumSet.allOf(ForgeDirection.class));
                AdjacentInventoryCache.this.invs.clear();
            }
        });
        this.filter = filter;
        this.sorter = sorter;
    }

    public Collection<IInventory> getAdjacentInventories() {
        Map<ForgeDirection, TileEntity> tiles = this.cache.refreshTiles();
        if (!this.changedSides.isEmpty()) {
            for (ForgeDirection side : this.changedSides) {
                IInventory inv;
                this.invs.remove(side);
                TileEntity tile = tiles.get(side);
                if (tile == null || this.filter != null && !this.filter.matches(tile) || (inv = InvTools.getInventoryFromTile(tile, side.getOpposite())) == null) continue;
                this.invs.put(side, inv);
            }
            this.changedSides.clear();
            this.sortedInvs.clear();
            this.sortedInvs.addAll(this.invs.values());
            if (this.sorter != null) {
                Collections.sort(this.sortedInvs, this.sorter);
            }
        }
        return this.sortedInvs;
    }
}

