/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Client.ParticleSystem;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.FloatBuffer;
import java.nio.charset.StandardCharsets;
import javax.vecmath.Vector3f;
import lumien.randomthings.Client.ParticleSystem.Particle;
import lumien.randomthings.RandomThings;
import org.apache.logging.log4j.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.glu.GLU;

public class ParticleSystem {
    int programID;
    int vertexShaderID;
    int fragmentShaderID;
    Vector3f emissionPoint;
    Particle[] particles;
    int lastUsedPosition;
    int maxParticles;
    int generationSpeed;
    int vertexBufferID;

    public ParticleSystem(Vector3f emissionPoint, int maxParticles, int generationSpeed) {
        this.particles = new Particle[maxParticles];
        this.maxParticles = 1;
        this.generationSpeed = generationSpeed;
        this.emissionPoint = emissionPoint;
        this.lastUsedPosition = 0;
        this.initiateParticles();
        this.inititateShaders();
        this.vertexBufferID = GL15.glGenBuffers();
    }

    private void initiateParticles() {
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new Particle();
        }
    }

    private void inititateShaders() {
        try {
            this.vertexShaderID = this.createShader("D:/development/vertex.shader", 35633);
            this.fragmentShaderID = this.createShader("D:/development/fragment.shader", 35632);
        }
        catch (Exception e) {
            e.printStackTrace();
            RandomThings.instance.logger.log(Level.WARN, "Couldn't initialize Shaders");
        }
        this.programID = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.programID, (int)this.vertexShaderID);
        GL20.glAttachShader((int)this.programID, (int)this.fragmentShaderID);
        GL20.glLinkProgram((int)this.programID);
        GL20.glDeleteShader((int)this.vertexShaderID);
        GL20.glDeleteShader((int)this.fragmentShaderID);
    }

    public void update() {
        for (int i = 0; i < this.generationSpeed; ++i) {
            int freeParticle = this.findUnusedParticle();
            if (freeParticle == -1) continue;
            Particle p = this.particles[freeParticle];
            p.setEnergy(200);
            p.setPosition(0.0f, 0.0f, 0.0f);
            p.setVelocity((float)Math.random() * 0.1f, 0.1f, (float)Math.random() * 0.1f);
            p.setGravity(0.0f, -0.001f, 0.0f);
        }
        for (Particle p : this.particles) {
            if (p.isDead()) continue;
            p.update();
        }
    }

    private int findUnusedParticle() {
        int i;
        for (i = this.lastUsedPosition; i < this.particles.length; ++i) {
            if (!this.particles[i].isDead()) continue;
            this.lastUsedPosition = i;
            return i;
        }
        for (i = 0; i < this.particles.length; ++i) {
            if (!this.particles[i].isDead()) continue;
            return i;
        }
        return -1;
    }

    private int getParticleCount() {
        int counter = 0;
        for (Particle p : this.particles) {
            if (p.isDead()) continue;
            ++counter;
        }
        return counter;
    }

    public void render(float partialTickTime) {
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        int particleCount = this.getParticleCount();
        FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(particleCount * 3));
        for (Particle p : this.particles) {
            if (p.isDead()) continue;
            vertexBuffer.put(p.pos.x + partialTickTime * p.velocity.x);
            vertexBuffer.put(p.pos.y + partialTickTime * p.velocity.y);
            vertexBuffer.put(p.pos.z + partialTickTime * p.velocity.z);
        }
        vertexBuffer.rewind();
        GL11.glPointSize((float)5.0f);
        GL20.glEnableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)this.vertexBufferID);
        GL15.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35040);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        GL11.glDrawArrays((int)0, (int)0, (int)particleCount);
        GL20.glDisableVertexAttribArray((int)0);
        GL15.glBindBuffer((int)34962, (int)0);
        GL20.glUseProgram((int)0);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }

    private void checkGLError(String p_71361_1_) {
        int i = GL11.glGetError();
        if (i != 0) {
            String s1 = GLU.gluErrorString((int)i);
            RandomThings.instance.logger.error("########## GL ERROR ##########");
            RandomThings.instance.logger.error("@ " + p_71361_1_);
            RandomThings.instance.logger.error(i + ": " + s1);
        }
    }

    private int createShader(String filename, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = GL20.glCreateShader((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            GL20.glShaderSource((int)shader, (CharSequence)this.readFileAsString(filename));
            GL20.glCompileShader((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader");
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block26: {
            source = new StringBuilder();
            FileInputStream in = new FileInputStream(filename);
            Exception exception = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        innerExc = exc;
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block26;
                throw exception;
            }
        }
        return source.toString();
    }
}

