/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.common.network.simpleimpl.SimpleIndexedCodec;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import lumien.randomthings.Network.IRTMessage;
import lumien.randomthings.Network.RTMessageHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;

public class RandomThingsNetworkWrapper
extends SimpleNetworkWrapper {
    private final EnumMap<Side, FMLEmbeddedChannel> channels;
    private final SimpleIndexedCodec packetCodec = new SimpleIndexedCodec();
    RTMessageHandler mh;
    int discriminator;

    public RandomThingsNetworkWrapper() {
        super("RandomThings".toLowerCase());
        this.channels = NetworkRegistry.INSTANCE.newChannel("RandomThings".toLowerCase(), new ChannelHandler[]{this.packetCodec});
        this.mh = new RTMessageHandler();
        FMLEmbeddedChannel channel = this.channels.get(Side.SERVER);
        String type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        this.addServerHandlerAfter(channel, type, this.mh, IRTMessage.class);
        channel = this.channels.get(Side.CLIENT);
        type = channel.findChannelHandlerNameForType(SimpleIndexedCodec.class);
        this.addClientHandlerAfter(channel, type, this.mh, IRTMessage.class);
        this.discriminator = 0;
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<REQ> requestMessageType) {
        this.packetCodec.addDiscriminator(this.discriminator++, requestMessageType);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addServerHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.SERVER, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName(), handler);
    }

    private <REQ extends IMessage, REPLY extends IMessage, NH extends INetHandler> void addClientHandlerAfter(FMLEmbeddedChannel channel, String type, IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestType) {
        SimpleChannelHandlerWrapper<? super REQ, ? extends REPLY> handler = this.getHandlerWrapper(messageHandler, Side.CLIENT, requestType);
        channel.pipeline().addAfter(type, messageHandler.getClass().getName(), handler);
    }

    private <REPLY extends IMessage, REQ extends IMessage> SimpleChannelHandlerWrapper<REQ, REPLY> getHandlerWrapper(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Side side, Class<REQ> requestType) {
        return new SimpleChannelHandlerWrapper(messageHandler, side, requestType);
    }

    public Packet getPacketFrom(IMessage message) {
        return this.channels.get(Side.SERVER).generatePacketFrom((Object)message);
    }

    public void sendToAll(IMessage message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(IMessage message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

