/*
 * Decompiled with CFR 0.152.
 */
package remoteio.client.helper;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;

public class TextFormatter {
    private static final char FORMATTING = '\u00a7';

    public static LinkedList<FormattedString> format(String string) {
        return TextFormatter.format(string, -1);
    }

    public static LinkedList<FormattedString> format(String string, int overrideColor) {
        String[] words;
        LinkedList list = Lists.newLinkedList();
        EnumSet<Format> activeFormats = EnumSet.noneOf(Format.class);
        int activeColor = -1;
        string = string.trim();
        for (String word : words = string.split(" ")) {
            if (word == null || word.isEmpty()) continue;
            word = word.trim();
            StringBuilder stringBuilder = new StringBuilder();
            EnumSet<Format> formats = EnumSet.copyOf(activeFormats);
            EnumSet<Format> toRemove = EnumSet.noneOf(Format.class);
            boolean resetColor = false;
            for (int i = 0; i < word.length(); ++i) {
                char character = word.charAt(i);
                if (overrideColor == -1 && character == '@') {
                    boolean terminator;
                    boolean bl = terminator = i == word.length() - 1 || word.charAt(i + 1) != '0' || word.length() <= i + 9 || activeColor != -1;
                    if (!terminator && activeColor != -1) {
                        activeColor = -1;
                        continue;
                    }
                    if (terminator) {
                        resetColor = true;
                    } else {
                        try {
                            activeColor = Integer.parseInt(word.substring(i + 3, i + 9), 16);
                        }
                        catch (NumberFormatException ex) {
                            activeColor = -1;
                            ex.printStackTrace();
                        }
                    }
                    if (activeColor == -1) continue;
                    i += 8;
                    continue;
                }
                Format format = Format.getFormat(character);
                if (format != null) {
                    if (formats.contains((Object)format)) {
                        toRemove.add(format);
                        continue;
                    }
                    formats.add(format);
                    continue;
                }
                stringBuilder.append(character);
            }
            if (overrideColor != -1) {
                activeColor = -1;
            }
            FormattedString formattedString = new FormattedString(stringBuilder.toString(), EnumSet.copyOf(formats), activeColor);
            formats.removeAll(toRemove);
            toRemove.clear();
            if (resetColor) {
                activeColor = -1;
            }
            formattedString.setContinuingFormat(formats, !resetColor);
            list.add(formattedString);
            activeFormats.clear();
            activeFormats.addAll(formats);
        }
        return list;
    }

    public static void draw(FontRenderer fontRenderer, LinkedList<FormattedString> list, int x, int y) {
        for (FormattedString formattedString : list) {
            formattedString.draw(fontRenderer, x, y);
            x += formattedString.getWidth(fontRenderer);
            x += fontRenderer.func_78263_a(' ');
            if (!formattedString.format.contains((Object)Format.BOLD)) continue;
            x += fontRenderer.func_78263_a(' ');
        }
    }

    public static enum Format {
        BOLD('*', 'l'),
        ITALIC('-', 'o'),
        UNDERLINE('_', 'n');

        public char token;
        public char code;

        private Format(char token, char code) {
            this.token = token;
            this.code = code;
        }

        public static Format getFormat(char token) {
            for (Format format : Format.values()) {
                if (format.token != token) continue;
                return format;
            }
            return null;
        }
    }

    public static class FormattedString {
        public String string;
        public EnumSet<Format> format;
        public int color;
        private EnumSet<Format> continuingFormats = EnumSet.noneOf(Format.class);
        private boolean continueColor = false;

        public FormattedString(String string) {
            this(string, EnumSet.noneOf(Format.class), 0xFFFFFF);
        }

        public FormattedString(String string, int color) {
            this(string, EnumSet.noneOf(Format.class), color);
        }

        public FormattedString(String string, EnumSet<Format> format) {
            this(string, format, 0xFFFFFF);
        }

        public FormattedString(String string, EnumSet<Format> format, int color) {
            this.string = string;
            this.format = format;
            this.color = color;
        }

        public FormattedString setContinuingFormat(EnumSet<Format> formats, boolean continueColor) {
            this.continuingFormats = formats;
            this.continueColor = continueColor;
            return this;
        }

        public int getWidth(FontRenderer fontRenderer) {
            return fontRenderer.func_78256_a(this.string);
        }

        public void draw(FontRenderer fontRenderer, int x, int y) {
            if (!this.format.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Format format1 : this.format) {
                    stringBuilder.append('\u00a7').append(format1.code);
                }
                stringBuilder.append(this.string);
                stringBuilder.append('\u00a7').append('r');
                fontRenderer.func_78276_b(stringBuilder.toString(), x, y, this.color);
                int length = fontRenderer.func_78256_a(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                x += length;
                if (!this.continuingFormats.isEmpty()) {
                    for (Format format2 : this.continuingFormats) {
                        stringBuilder.append('\u00a7').append(format2.code);
                    }
                    stringBuilder.append(" ");
                    stringBuilder.append('\u00a7').append('r');
                }
                fontRenderer.func_78276_b(stringBuilder.toString(), x, y, this.continueColor ? this.color : 0xFFFFFF);
            } else {
                fontRenderer.func_78276_b(this.string, x, y, this.color);
            }
        }

        public String toString() {
            return this.string + (!this.format.isEmpty() ? " " + this.format.toString() : "");
        }
    }
}

