/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.tile.core;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import remoteio.common.core.helper.InventoryHelper;
import remoteio.common.inventory.InventoryItem;
import remoteio.common.inventory.InventoryNBT;
import remoteio.common.lib.ModItems;
import remoteio.common.lib.VisualState;
import remoteio.common.tile.core.TileCore;

public abstract class TileIOCore
extends TileCore
implements InventoryNBT.IInventoryCallback {
    public VisualState visualState = VisualState.INACTIVE;
    public ItemStack simpleCamo;
    public InventoryNBT transferChips = new InventoryNBT(this, 9, 1);
    public InventoryNBT upgradeChips = new InventoryNBT(this, 9, 1);

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.transferChips.writeToNBT("TransferChips", nbt);
        this.upgradeChips.writeToNBT("UpgradeChips", nbt);
        if (this.simpleCamo != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            this.simpleCamo.func_77955_b(nbtTagCompound);
            nbt.func_74782_a("simple", (NBTBase)nbtTagCompound);
        }
        nbt.func_74774_a("state", (byte)this.visualState.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.transferChips.readFromNBT("TransferChips", nbt);
        this.upgradeChips.readFromNBT("UpgradeChips", nbt);
        this.simpleCamo = nbt.func_74764_b("simple") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("simple")) : null;
        this.visualState = VisualState.values()[nbt.func_74771_c("state")];
    }

    @Override
    public void onClientUpdate(NBTTagCompound nbt) {
        if (nbt.func_74764_b("state")) {
            this.visualState = VisualState.values()[nbt.func_74771_c("state")];
        }
        this.simpleCamo = nbt.func_74764_b("simple") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("simple")) : null;
    }

    public boolean hasTransferChip(int type) {
        return InventoryHelper.containsStack((IInventory)this.transferChips, new ItemStack(ModItems.transferChip, 1, type), true, false);
    }

    public boolean hasUpgradeChip(int type) {
        return InventoryHelper.containsStack((IInventory)this.upgradeChips, new ItemStack(ModItems.upgradeChip, 1, type), true, false);
    }

    public void updateSimpleCamouflage() {
        for (ItemStack stack1 : InventoryHelper.toArray((IInventory)this.upgradeChips)) {
            ItemStack stack;
            if (stack1 == null || stack1.func_77960_j() != 2 || (stack = new InventoryItem(stack1, 1).func_70301_a(0)) == null) continue;
            this.simpleCamo = stack;
            this.sendSimpleCamouflage(stack);
            break;
        }
    }

    public void sendSimpleCamouflage(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (stack != null) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.func_77955_b(tag);
            nbt.func_74782_a("simple", (NBTBase)tag);
        } else {
            nbt.func_74757_a("simple_null", true);
        }
        this.sendClientUpdate(nbt);
    }

    public abstract VisualState calculateVisualState();

    public void updateVisualState() {
        VisualState state;
        this.visualState = state = this.calculateVisualState();
        this.sendVisualState(state);
    }

    public void sendVisualState(VisualState visualState) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", (byte)visualState.ordinal());
        this.sendClientUpdate(nbt);
        if (visualState == VisualState.CAMOUFLAGE_SIMPLE || visualState == VisualState.CAMOUFLAGE_BOTH) {
            this.updateSimpleCamouflage();
        }
    }
}

