/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.renderer;

import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.core.util.vector.Vector3f;
import com.github.lunatrius.schematica.client.renderer.RenderHelper;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.client.renderer.shader.ShaderProgram;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.profiler.Profiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class RendererSchematicChunk {
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("schematica", null, "shaders/alpha.frag");
    private static boolean canUpdate = false;
    public boolean isInFrustrum = false;
    public final Vector3d centerPosition = new Vector3d();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final Profiler profiler;
    private final SchematicWorld schematic;
    private final List<TileEntity> tileEntities;
    private final Vector3d distance;
    private final AxisAlignedBB boundingBox;
    private boolean needsUpdate;
    private int glList;
    private int glListHighlight;

    public RendererSchematicChunk(SchematicWorld schematicWorld, int baseX, int baseY, int baseZ) {
        this.profiler = this.minecraft.field_71424_I;
        this.tileEntities = new ArrayList<TileEntity>();
        this.distance = new Vector3d();
        this.boundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.needsUpdate = true;
        this.glList = -1;
        this.glListHighlight = -1;
        this.schematic = schematicWorld;
        this.boundingBox.func_72324_b((double)(baseX * 16), (double)(baseY * 16), (double)(baseZ * 16), (double)((baseX + 1) * 16), (double)((baseY + 1) * 16), (double)((baseZ + 1) * 16));
        this.centerPosition.x = (int)(((double)baseX + 0.5) * 16.0);
        this.centerPosition.y = (int)(((double)baseY + 0.5) * 16.0);
        this.centerPosition.z = (int)(((double)baseZ + 0.5) * 16.0);
        for (TileEntity tileEntity : this.schematic.getTileEntities()) {
            int x = tileEntity.field_145851_c;
            int y = tileEntity.field_145848_d;
            int z = tileEntity.field_145849_e;
            if ((double)x < this.boundingBox.field_72340_a || (double)x >= this.boundingBox.field_72336_d || (double)z < this.boundingBox.field_72339_c || (double)z >= this.boundingBox.field_72334_f || (double)y < this.boundingBox.field_72338_b || (double)y >= this.boundingBox.field_72337_e) continue;
            this.tileEntities.add(tileEntity);
        }
        this.glList = GL11.glGenLists((int)3);
        this.glListHighlight = GL11.glGenLists((int)3);
    }

    public void delete() {
        if (this.glList != -1) {
            GL11.glDeleteLists((int)this.glList, (int)3);
        }
        if (this.glListHighlight != -1) {
            GL11.glDeleteLists((int)this.glListHighlight, (int)3);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public static void setCanUpdate(boolean parCanUpdate) {
        canUpdate = parCanUpdate;
    }

    public static boolean getCanUpdate() {
        return canUpdate;
    }

    public void setDirty() {
        this.needsUpdate = true;
    }

    public boolean getDirty() {
        return this.needsUpdate;
    }

    public void updateRenderer() {
        if (this.needsUpdate) {
            this.needsUpdate = false;
            RendererSchematicChunk.setCanUpdate(false);
            RenderHelper.createBuffers();
            for (int pass = 0; pass < 3; ++pass) {
                RenderHelper.initBuffers();
                int minX = (int)this.boundingBox.field_72340_a;
                int maxX = Math.min((int)this.boundingBox.field_72336_d, this.schematic.getWidth());
                int minY = (int)this.boundingBox.field_72338_b;
                int maxY = Math.min((int)this.boundingBox.field_72337_e, this.schematic.func_72800_K());
                int minZ = (int)this.boundingBox.field_72339_c;
                int maxZ = Math.min((int)this.boundingBox.field_72334_f, this.schematic.getLength());
                int renderingLayer = this.schematic.renderingLayer;
                if (this.schematic.isRenderingLayer) {
                    if (renderingLayer >= minY && renderingLayer < maxY) {
                        minY = renderingLayer;
                        maxY = renderingLayer + 1;
                    } else {
                        maxY = 0;
                        minY = 0;
                    }
                }
                GL11.glNewList((int)(this.glList + pass), (int)4864);
                this.renderBlocks(pass, minX, minY, minZ, maxX, maxY, maxZ);
                GL11.glEndList();
                GL11.glNewList((int)(this.glListHighlight + pass), (int)4864);
                int quadCount = RenderHelper.getQuadCount();
                int lineCount = RenderHelper.getLineCount();
                if (quadCount > 0 || lineCount > 0) {
                    GL11.glDisable((int)3553);
                    GL11.glLineWidth((float)1.5f);
                    GL11.glEnableClientState((int)32884);
                    GL11.glEnableClientState((int)32886);
                    if (quadCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getQuadVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getQuadColorBuffer());
                        GL11.glDrawArrays((int)7, (int)0, (int)quadCount);
                    }
                    if (lineCount > 0) {
                        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)RenderHelper.getLineVertexBuffer());
                        GL11.glColorPointer((int)4, (int)0, (FloatBuffer)RenderHelper.getLineColorBuffer());
                        GL11.glDrawArrays((int)1, (int)0, (int)lineCount);
                    }
                    GL11.glDisableClientState((int)32886);
                    GL11.glDisableClientState((int)32884);
                    GL11.glEnable((int)3553);
                }
                GL11.glEndList();
            }
            RenderHelper.destroyBuffers();
        }
    }

    public void render(int renderPass) {
        if (!this.isInFrustrum) {
            return;
        }
        if (this.distance.set(ClientProxy.playerPosition).sub((double)this.schematic.position.x, (double)this.schematic.position.y, (double)this.schematic.position.z).sub(this.centerPosition).lengthSquared() > 25600.0) {
            return;
        }
        GL11.glDisable((int)2896);
        this.profiler.func_76320_a("blocks");
        this.minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (OpenGlHelper.field_148824_g && ConfigurationHandler.enableAlpha) {
            GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)ConfigurationHandler.alpha);
        }
        GL11.glCallList((int)(this.glList + renderPass));
        if (OpenGlHelper.field_148824_g && ConfigurationHandler.enableAlpha) {
            GL20.glUseProgram((int)0);
        }
        this.profiler.func_76318_c("highlight");
        GL11.glCallList((int)(this.glListHighlight + renderPass));
        this.profiler.func_76318_c("tileEntities");
        this.renderTileEntities(renderPass);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.profiler.func_76319_b();
    }

    public void renderBlocks(int renderPass, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        WorldClient mcWorld = this.minecraft.field_71441_e;
        RenderBlocks renderBlocks = RendererSchematicGlobal.INSTANCE.renderBlocks;
        Vector3f zero = new Vector3f();
        Vector3f size = new Vector3f();
        int ambientOcclusion = this.minecraft.field_71474_y.field_74348_k;
        this.minecraft.field_71474_y.field_74348_k = 0;
        Tessellator.field_78398_a.func_78382_b();
        for (int y = minY; y < maxY; ++y) {
            for (int z = minZ; z < maxZ; ++z) {
                for (int x = minX; x < maxX; ++x) {
                    try {
                        boolean isMcAirBlock;
                        Block block = this.schematic.func_147439_a(x, y, z);
                        int wx = this.schematic.position.x + x;
                        int wy = this.schematic.position.y + y;
                        int wz = this.schematic.position.z + z;
                        Block mcBlock = mcWorld.func_147439_a(wx, wy, wz);
                        int sides = 0;
                        if (block != null) {
                            if (block.func_149646_a((IBlockAccess)this.schematic, x, y - 1, z, 0)) {
                                sides |= 1;
                            }
                            if (block.func_149646_a((IBlockAccess)this.schematic, x, y + 1, z, 1)) {
                                sides |= 2;
                            }
                            if (block.func_149646_a((IBlockAccess)this.schematic, x, y, z - 1, 2)) {
                                sides |= 4;
                            }
                            if (block.func_149646_a((IBlockAccess)this.schematic, x, y, z + 1, 3)) {
                                sides |= 8;
                            }
                            if (block.func_149646_a((IBlockAccess)this.schematic, x - 1, y, z, 4)) {
                                sides |= 0x10;
                            }
                            if (block.func_149646_a((IBlockAccess)this.schematic, x + 1, y, z, 5)) {
                                sides |= 0x20;
                            }
                        }
                        boolean isAirBlock = this.schematic.func_147437_c(x, y, z);
                        boolean bl = isMcAirBlock = mcWorld.func_147437_c(wx, wy, wz) || ConfigurationHandler.isExtraAirBlock(mcBlock);
                        if (!isMcAirBlock) {
                            if (!ConfigurationHandler.highlight || renderPass != 2) continue;
                            if (isAirBlock && ConfigurationHandler.highlightAir) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (ConfigurationHandler.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                }
                                if (!ConfigurationHandler.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, 63, 0.75f, 0.0f, 0.75f, 0.25f);
                                continue;
                            }
                            if (block != mcBlock) {
                                zero.set((float)x, (float)y, (float)z);
                                size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                                if (ConfigurationHandler.drawQuads) {
                                    RenderHelper.drawCuboidSurface(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                }
                                if (!ConfigurationHandler.drawLines) continue;
                                RenderHelper.drawCuboidOutline(zero, size, sides, 1.0f, 0.0f, 0.0f, 0.25f);
                                continue;
                            }
                            if (this.schematic.func_72805_g(x, y, z) == mcWorld.func_72805_g(wx, wy, wz)) continue;
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (ConfigurationHandler.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            }
                            if (!ConfigurationHandler.drawLines) continue;
                            RenderHelper.drawCuboidOutline(zero, size, sides, 0.75f, 0.35f, 0.0f, 0.25f);
                            continue;
                        }
                        if (isAirBlock) continue;
                        if (ConfigurationHandler.highlight && renderPass == 2) {
                            zero.set((float)x, (float)y, (float)z);
                            size.set((float)(x + 1), (float)(y + 1), (float)(z + 1));
                            if (ConfigurationHandler.drawQuads) {
                                RenderHelper.drawCuboidSurface(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                            if (ConfigurationHandler.drawLines) {
                                RenderHelper.drawCuboidOutline(zero, size, sides, 0.0f, 0.75f, 1.0f, 0.25f);
                            }
                        }
                        if (block == null || !block.canRenderInPass(renderPass)) continue;
                        renderBlocks.func_147805_b(block, x, y, z);
                        continue;
                    }
                    catch (Exception e) {
                        Reference.logger.error("Failed to render block!", (Throwable)e);
                    }
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        this.minecraft.field_71474_y.field_74348_k = ambientOcclusion;
    }

    public void renderTileEntities(int renderPass) {
        if (renderPass != 0) {
            return;
        }
        WorldClient mcWorld = this.minecraft.field_71441_e;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)ConfigurationHandler.alpha);
        try {
            for (TileEntity tileEntity : this.tileEntities) {
                TileEntitySpecialRenderer tileEntitySpecialRenderer;
                boolean isAirBlock;
                int x = tileEntity.field_145851_c;
                int y = tileEntity.field_145848_d;
                int z = tileEntity.field_145849_e;
                if (this.schematic.isRenderingLayer && this.schematic.renderingLayer != y || !(isAirBlock = mcWorld.func_147437_c(x + this.schematic.position.x, y + this.schematic.position.y, z + this.schematic.position.z)) || (tileEntitySpecialRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity)) == null) continue;
                try {
                    tileEntitySpecialRenderer.func_147500_a(tileEntity, (double)x, (double)y, (double)z, 0.0f);
                    OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
                    GL11.glDisable((int)3553);
                    OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
                }
                catch (Exception e) {
                    Reference.logger.error("Failed to render a tile entity!", (Throwable)e);
                }
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)ConfigurationHandler.alpha);
            }
        }
        catch (Exception ex) {
            Reference.logger.error("Failed to render tile entities!", (Throwable)ex);
        }
    }
}

