/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.lib.EnumMessageLocation;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigString;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.text_components.Notification;

@EventBusSubscriber(side={Side.CLIENT})
public class NotificationHandler {
    private static final Deque<Notification> NOTIFICATIONS = new ArrayDeque<Notification>();
    private static final Map<String, IChatComponent> lastMessages = new HashMap<String, IChatComponent>();
    private static ConfigGroup notificationConfig;
    private static NotificationWidget currentNotification;

    public static void onNotify(IChatComponent component) {
        EnumMessageLocation location;
        Minecraft mc = Minecraft.func_71410_x();
        if (!(component instanceof Notification)) {
            mc.field_71439_g.func_145747_a(component);
            return;
        }
        Notification notification = (Notification)component;
        ResourceLocation id = notification.getId();
        ServerUtilitiesNotifications notificationType = ServerUtilitiesNotifications.getFromId(id);
        EnumMessageLocation enumMessageLocation = location = notificationType == null || notification.isImportant() ? EnumMessageLocation.ACTION_BAR : notificationType.getLocation();
        if (location == EnumMessageLocation.OFF) {
            return;
        }
        lastMessages.put(id.func_110623_a(), (IChatComponent)notification);
        if (location == EnumMessageLocation.CHAT) {
            mc.field_71439_g.func_145747_a(component);
            return;
        }
        if (notification.isVanilla()) {
            mc.field_71456_v.func_110326_a(component.func_150254_d(), false);
            return;
        }
        NOTIFICATIONS.remove((Object)notification);
        if (currentNotification != null && NotificationHandler.currentNotification.id.equals((Object)id)) {
            currentNotification = null;
        }
        NOTIFICATIONS.add(notification);
    }

    public static void updateDescription(ConfigValueInstance inst) {
        IChatComponent notification = lastMessages.get(inst.getId());
        if (notification == null) {
            return;
        }
        IChatComponent info = inst.getInfo();
        if (info == null) {
            return;
        }
        info.func_150253_a().clear();
        info.func_150258_a("\n" + StatCollector.func_74838_a((String)"serverutilities.notifications.last_received") + "\n").func_150257_a(notification);
    }

    static void loadNotifications() {
        JsonElement file = JsonUtils.fromJson(new File("serverutilities/client/notifications.json"));
        if (JsonUtils.isNull(file)) {
            return;
        }
        ConfigGroup group = NotificationHandler.getNotificationConfig();
        for (Map.Entry entry : file.getAsJsonObject().entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            group.getValue((String)entry.getKey()).setValueFromString(null, obj.getAsJsonPrimitive("location").getAsString().toLowerCase(), false);
            if (!obj.has("lastReceived")) continue;
            IChatComponent last = JsonUtils.deserializeTextComponent((JsonElement)obj.getAsJsonObject("lastReceived"));
            lastMessages.put((String)entry.getKey(), last);
        }
    }

    public static void saveConfig(ConfigGroup group, ICommandSender sender) {
        JsonObject json = new JsonObject();
        for (ServerUtilitiesNotifications notification : ServerUtilitiesNotifications.VALUES) {
            JsonObject obj = new JsonObject();
            obj.add("location", (JsonElement)new JsonPrimitive(notification.getLocation().name()));
            IChatComponent last = lastMessages.get(notification.getId());
            if (last != null) {
                obj.add("lastReceived", JsonUtils.serializeTextComponent(last));
            }
            json.add(notification.getId(), (JsonElement)obj);
        }
        JsonUtils.toJsonSafe(new File("serverutilities/client/notifications.json"), (JsonElement)json);
    }

    public static ConfigGroup getNotificationConfig() {
        if (notificationConfig != null) {
            return notificationConfig;
        }
        notificationConfig = ConfigGroup.newGroup("notifications").setDisplayName(ServerUtilities.lang("serverutilities.notifications.config", new Object[0]));
        for (ServerUtilitiesNotifications notification : ServerUtilitiesNotifications.values()) {
            notificationConfig.addEnum(notification.getId(), notification::getLocation, notification::setLocation, EnumMessageLocation.NAME_MAP).setDefaultValue(new ConfigString(notification.getLocation().name())).setDisplayName((IChatComponent)new ChatComponentTranslation("serverutilities.notifications." + notification.getId(), new Object[0])).setInfo((IChatComponent)new ChatComponentText(notification.getDesc()));
        }
        return notificationConfig;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                currentNotification = null;
                NOTIFICATIONS.clear();
            }
            if (currentNotification != null && NotificationHandler.currentNotification.tick()) {
                currentNotification = null;
            }
            if (currentNotification == null && !NOTIFICATIONS.isEmpty()) {
                currentNotification = new NotificationWidget(NOTIFICATIONS.pop());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGameOverlayRender(RenderGameOverlayEvent.Text event) {
        if (currentNotification != null && !NotificationHandler.currentNotification.isImportant()) {
            currentNotification.render(event.resolution, event.partialTicks);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.enableTexture2D();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (currentNotification != null && NotificationHandler.currentNotification.isImportant()) {
            Minecraft mc = Minecraft.func_71410_x();
            currentNotification.render(new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d), event.renderTickTime);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.enableTexture2D();
        }
    }

    private static class NotificationWidget {
        private static final FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        public final Notification notification;
        public final ResourceLocation id;
        public final List<String> text;
        public int width;
        public int height;
        public final long timer;
        private long tick;
        private long endTick;

        public NotificationWidget(Notification n) {
            String s0;
            this.notification = n;
            this.id = n.getId();
            this.width = 0;
            this.text = new ArrayList<String>();
            this.timer = n.getTimer().ticks();
            this.endTick = -1L;
            this.tick = -1L;
            try {
                s0 = this.notification.func_150254_d();
            }
            catch (Exception ex) {
                s0 = EnumChatFormatting.RED + ex.toString();
            }
            Minecraft mc = Minecraft.func_71410_x();
            for (String s : font.func_78271_c(s0, new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d).func_78326_a())) {
                for (String line : s.split("\n")) {
                    if (line.isEmpty()) continue;
                    line = line.trim();
                    this.text.add(line);
                    this.width = Math.max(this.width, font.func_78256_a(line));
                }
            }
            this.width += 4;
            this.height = this.text.size() * 11;
            if (this.text.isEmpty()) {
                this.width = 20;
                this.height = 20;
            }
        }

        public void render(ScaledResolution screen, float partialTicks) {
            if (this.tick == -1L || this.tick >= this.endTick) {
                return;
            }
            int alpha = (int)Math.min(255.0f, ((float)(this.endTick - this.tick) - partialTicks) * 255.0f / 20.0f);
            if (alpha <= 2) {
                return;
            }
            GlStateManager.pushMatrix();
            GlStateManager.disableDepth();
            GlStateManager.depthMask(false);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            int width = screen.func_78326_a() / 2;
            int height = screen.func_78328_b() - 67;
            int offy = this.text.size() * 11 / 2;
            for (int i = 0; i < this.text.size(); ++i) {
                String string = this.text.get(i);
                font.func_78261_a(string, width - font.func_78256_a(string) / 2, height - offy + i * 11, 0xFFFFFF | alpha << 24);
            }
            GlStateManager.depthMask(true);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
            GlStateManager.enableDepth();
        }

        private boolean tick() {
            this.tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (this.endTick == -1L) {
                this.endTick = this.tick + this.timer;
            }
            return this.tick >= this.endTick || Math.min(255.0f, (float)(this.endTick - this.tick) * 255.0f / 20.0f) <= 2.0f;
        }

        private boolean isImportant() {
            return this.notification.isImportant();
        }
    }
}

