/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command.chunks;

import java.util.List;
import java.util.OptionalInt;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import serverutils.ServerUtilities;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.Universe;

public class CmdUnloadEverything
extends CmdBase {
    public CmdUnloadEverything() {
        super("unload_everything", CmdBase.Level.OP_OR_SP);
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CmdUnloadEverything.func_71531_a((String[])args, CommandUtils.getDimensionNames());
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (!ClaimedChunks.isActive()) {
            throw ServerUtilities.error(sender, "feature_disabled_server", new Object[0]);
        }
        OptionalInt dimension = CommandUtils.parseDimension(sender, args, 0);
        for (ForgeTeam team : Universe.get().getTeams()) {
            for (ClaimedChunk chunk : ClaimedChunks.instance.getTeamChunks(team, dimension)) {
                chunk.setLoaded(false);
            }
        }
    }
}

