/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.util.INBTSerializable;
import serverutils.lib.util.NBTUtils;

public class VanishData
implements INBTSerializable<NBTTagCompound> {
    public boolean interaction;
    public boolean chat;
    public boolean damageOthers;
    public boolean collision;
    public boolean sendConnectionMessage;
    public boolean containerReadOnly;
    public boolean itemDropping;

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("interaction", this.interaction);
        nbt.func_74757_a("chat", this.chat);
        nbt.func_74757_a("damageOthers", this.damageOthers);
        nbt.func_74757_a("collision", this.collision);
        nbt.func_74757_a("sendConnectionMsg", this.sendConnectionMessage);
        nbt.func_74757_a("containerReadOnly", this.containerReadOnly);
        nbt.func_74757_a("itemDropping", this.itemDropping);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.interaction = nbt.func_74767_n("interaction");
        this.chat = nbt.func_74767_n("chat");
        this.damageOthers = nbt.func_74767_n("damageOthers");
        this.collision = nbt.func_74767_n("collision");
        this.sendConnectionMessage = nbt.func_74767_n("sendConnectionMsg");
        this.containerReadOnly = NBTUtils.getBooleanOrTrue(nbt, "containerReadOnly");
        this.itemDropping = nbt.func_74767_n("itemDropping");
    }

    public void addConfigs(ConfigGroup group) {
        ConfigGroup vanishGroup = group.getGroup("vanish");
        vanishGroup.addBool("interaction", () -> this.interaction, b -> {
            this.interaction = b;
        }, false);
        vanishGroup.addBool("chat", () -> this.chat, b -> {
            this.chat = b;
        }, false);
        vanishGroup.addBool("damageOther", () -> this.damageOthers, b -> {
            this.damageOthers = b;
        }, false);
        vanishGroup.addBool("collision", () -> this.collision, b -> {
            this.collision = b;
        }, false);
        vanishGroup.addBool("sendConnectionMsg", () -> this.sendConnectionMessage, b -> {
            this.sendConnectionMessage = b;
        }, false);
        vanishGroup.addBool("containerReadOnly", () -> this.containerReadOnly, b -> {
            this.containerReadOnly = b;
        }, true);
        vanishGroup.addBool("itemDropping", () -> this.itemDropping, b -> {
            this.itemDropping = b;
        }, false);
    }

    public boolean setState(DataType type, boolean state) {
        boolean bl;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INTERACTION: {
                bl = this.interaction = state;
                break;
            }
            case CHAT: {
                bl = this.chat = state;
                break;
            }
            case DAMAGE_OTHERS: {
                bl = this.damageOthers = state;
                break;
            }
            case COLLISION: {
                bl = this.collision = state;
                break;
            }
            case SEND_CONNECTION_MESSAGE: {
                bl = this.sendConnectionMessage = state;
                break;
            }
            case CONTAINER_READ_ONLY: {
                bl = this.containerReadOnly = state;
                break;
            }
            case ITEM_DROPPING: {
                bl = this.itemDropping = state;
            }
        }
        return bl;
    }

    public boolean toggleState(DataType type) {
        boolean bl;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case INTERACTION: {
                bl = this.interaction = !this.interaction;
                break;
            }
            case CHAT: {
                bl = this.chat = !this.chat;
                break;
            }
            case DAMAGE_OTHERS: {
                bl = this.damageOthers = !this.damageOthers;
                break;
            }
            case COLLISION: {
                bl = this.collision = !this.collision;
                break;
            }
            case SEND_CONNECTION_MESSAGE: {
                bl = this.sendConnectionMessage = !this.sendConnectionMessage;
                break;
            }
            case CONTAINER_READ_ONLY: {
                bl = this.containerReadOnly = !this.containerReadOnly;
                break;
            }
            case ITEM_DROPPING: {
                bl = this.itemDropping = !this.itemDropping;
            }
        }
        return bl;
    }

    public static enum DataType {
        INTERACTION("interact"),
        CHAT("chat"),
        COLLISION("collision"),
        DAMAGE_OTHERS("damage_other"),
        SEND_CONNECTION_MESSAGE("send_connection_msg"),
        CONTAINER_READ_ONLY("container_read_only"),
        ITEM_DROPPING("item_dropping");

        public final String name;
        public final String desc;

        private DataType(String name) {
            this.name = name;
            this.desc = StatCollector.func_74838_a((String)("player_config.vanish." + name.replace("_", "") + ".tooltip"));
        }
    }
}

