/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.navigator;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.util.ClickPos;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.client.gui.ClientClaimedChunks;
import serverutils.integration.navigator.ClaimsLayerManager;
import serverutils.integration.navigator.ClaimsLocation;
import serverutils.lib.math.ChunkDimPos;
import serverutils.net.MessageClaimedChunksModify;
import serverutils.net.MessageClaimedChunksUpdate;
import serverutils.net.MessageNavigatorRequest;
import serverutils.net.MessageNavigatorUpdate;

public class NavigatorIntegration {
    public static final Object2ObjectMap<ChunkDimPos, ClientClaimedChunks.ChunkData> CLAIMS = new Object2ObjectOpenHashMap();
    public static ClientClaimedChunks.ChunkData OWNTEAM = null;
    public static int maxClaimedChunks;
    public static int currentClaimedChunks;
    static final ChunkDimPos mutablePos;

    public static void init() {
        NavigatorApi.registerLayerManager((LayerManager)ClaimsLayerManager.INSTANCE);
    }

    public static void updateMap(MessageNavigatorUpdate message) {
        for (ClientClaimedChunks.Team team : message.teams.values()) {
            for (Object2ObjectMap.Entry pos : team.chunkPos.object2ObjectEntrySet()) {
                ChunkDimPos location = (ChunkDimPos)pos.getKey();
                ClientClaimedChunks.ChunkData newData = (ClientClaimedChunks.ChunkData)pos.getValue();
                ClientClaimedChunks.ChunkData oldData = (ClientClaimedChunks.ChunkData)CLAIMS.get((Object)location);
                if (oldData == null) {
                    CLAIMS.put((Object)location, (Object)newData);
                    continue;
                }
                oldData.setLoaded(newData.isLoaded());
                oldData.setTeam(newData.team);
            }
            ClaimsLayerManager.INSTANCE.forceRefresh();
            if (OWNTEAM != null || !team.isMember) continue;
            OWNTEAM = ((ClientClaimedChunks.ChunkData)team.chunkPos.values().iterator().next()).copy().setLoaded(false);
        }
    }

    public static void addToOwnTeam(int chunkX, int chunkZ) {
        if (OWNTEAM == null) {
            return;
        }
        if (currentClaimedChunks >= maxClaimedChunks) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        CLAIMS.put((Object)new ChunkDimPos(chunkX, chunkZ, mc.field_71439_g.field_71093_bK), (Object)OWNTEAM.copy());
        ClaimsLayerManager.INSTANCE.forceRefresh();
    }

    public static void removeChunk(int chunkX, int chunkZ) {
        int dim = Minecraft.func_71410_x().field_71439_g.field_71093_bK;
        ClaimsLayerManager.INSTANCE.removeLocation(chunkX, chunkZ);
        CLAIMS.remove((Object)mutablePos.set(chunkX, chunkZ, dim));
    }

    public static void unclaimChunk(ClaimsLocation location) {
        if (!location.isOwnTeam()) {
            return;
        }
        int chunkX = location.getChunkX();
        int chunkZ = location.getChunkZ();
        int selectionMode = 1;
        Set<ChunkCoordIntPair> chunks = Collections.singleton(new ChunkCoordIntPair(chunkX, chunkZ));
        new MessageClaimedChunksModify(chunkX, chunkZ, selectionMode, chunks).sendToServer();
        NavigatorIntegration.removeChunk(location.getChunkX(), location.getChunkZ());
    }

    public static void onChunkDataUpdate(MessageClaimedChunksUpdate message) {
        maxClaimedChunks = message.maxClaimedChunks;
        currentClaimedChunks = message.claimedChunks;
    }

    public static boolean claimChunk(ClickPos pos) {
        if (pos.getRenderStep() != null || !pos.isDoubleClick()) {
            return false;
        }
        int selectionMode = 0;
        int chunkX = pos.getChunkX();
        int chunkZ = pos.getChunkZ();
        Set<ChunkCoordIntPair> chunk = Collections.singleton(new ChunkCoordIntPair(chunkX, chunkZ));
        new MessageClaimedChunksModify(chunkX, chunkZ, selectionMode, chunk).sendToServer();
        if (OWNTEAM == null) {
            new MessageNavigatorRequest(chunkX, chunkX, chunkZ, chunkZ).sendToServer();
        } else {
            NavigatorIntegration.addToOwnTeam(chunkX, chunkZ);
        }
        return true;
    }

    static {
        mutablePos = new ChunkDimPos();
    }
}

