/*
 * Decompiled with CFR 0.152.
 */
package serverutils.invsee.inventories;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.core.inventory.SlotExtendedInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import serverutils.invsee.inventories.IModdedInventory;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ImageIcon;
import serverutils.lib.icon.ItemIcon;
import serverutils.lib.icon.PartIcon;

public class GalacticraftInventory
implements IModdedInventory {
    private static final Icon[] SLOT_OVERLAYS = new Icon[10];
    private static final Icon GC_BUTTON_ICON = ItemIcon.getItemIcon(GCItems.oxMask);
    private static final String GC_EXTENDED_INV = "ExtendedInventoryGC";

    @Override
    @Nullable
    public IInventory loadOnlineInventory(EntityPlayerMP player) {
        return GCPlayerStats.get((EntityPlayerMP)player).extendedInventory;
    }

    @Override
    @Nullable
    public IInventory loadOfflineInventory(ForgePlayer player) {
        InventoryExtended inventory = new InventoryExtended();
        NBTTagCompound gcStats = player.getPlayerNBT().func_74775_l("GCPlayerStats");
        inventory.readFromNBT(gcStats.func_150295_c(GC_EXTENDED_INV, 10));
        return inventory;
    }

    @Override
    @NotNull
    public IInventory createInventory(EntityPlayer player, int size) {
        return new InventoryExtended();
    }

    @Override
    @NotNull
    public Icon getButtonIcon() {
        return GC_BUTTON_ICON;
    }

    @Override
    @NotNull
    public String getButtonText() {
        return "Galacticraft";
    }

    @Override
    public String getInventoryName() {
        return "GC Items";
    }

    @Override
    @Nullable
    public Slot getSlot(EntityPlayer player, IInventory inventory, int index, int x, int y) {
        SlotExtendedInventory slotExtendedInventory;
        switch (index) {
            case 0: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 100, 17);
                break;
            }
            case 1: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 100, 35);
                break;
            }
            case 2: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 91, 53);
                break;
            }
            case 3: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 109, 53);
                break;
            }
            case 4: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 118, 17);
                break;
            }
            case 5: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 82, 17);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                slotExtendedInventory = new SlotExtendedInventory(inventory, index, 54, 8 + (index - 6) * 18);
                break;
            }
            default: {
                slotExtendedInventory = null;
            }
        }
        return slotExtendedInventory;
    }

    @Override
    @Nullable
    public Icon getSlotOverlay(Slot slot) {
        if (slot.getSlotIndex() >= 10) {
            return null;
        }
        return SLOT_OVERLAYS[slot.getSlotIndex()];
    }

    @Override
    public void saveInventory(ForgePlayer player, IInventory inventory) {
        if (player.isOnline()) {
            return;
        }
        NBTTagCompound tag = player.getPlayerNBT();
        NBTTagCompound gcStats = tag.func_74775_l("GCPlayerStats");
        NBTTagList invList = new NBTTagList();
        ((InventoryExtended)inventory).writeToNBT(invList);
        gcStats.func_74782_a(GC_EXTENDED_INV, (NBTBase)invList);
        tag.func_74782_a("GCPlayerStats", (NBTBase)gcStats);
        player.setPlayerNBT(tag);
    }

    static {
        ImageIcon icon = new ImageIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/inventory.png"));
        for (int i = 0; i < 10; ++i) {
            Icon icon2;
            switch (i) {
                case 0: {
                    icon2 = new PartIcon(icon, 125, 17, 16, 16, 4);
                    break;
                }
                case 1: {
                    icon2 = new PartIcon(icon, 125, 35, 16, 16, 4);
                    break;
                }
                case 2: 
                case 3: {
                    icon2 = new PartIcon(icon, 116, 53, 16, 16, 4);
                    break;
                }
                case 4: {
                    icon2 = new PartIcon(icon, 143, 17, 16, 16, 4);
                    break;
                }
                case 5: {
                    icon2 = new PartIcon(icon, 107, 17, 16, 16, 4);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    icon2 = new PartIcon(icon, 79, 8 + (i - 6) * 18, 16, 16, 4);
                    break;
                }
                default: {
                    icon2 = ItemIcon.EMPTY;
                }
            }
            GalacticraftInventory.SLOT_OVERLAYS[i] = icon2;
        }
    }
}

