/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib;

import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import serverutils.lib.EnumDyeColor;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.EnumDyeColorHelper;
import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.misc.NameMap;

public enum EnumTeamColor implements IStringSerializable
{
    BLUE("blue", EnumDyeColor.BLUE, EnumChatFormatting.BLUE, 38143),
    CYAN("cyan", EnumDyeColor.CYAN, EnumChatFormatting.AQUA, 56831),
    GREEN("green", EnumDyeColor.GREEN, EnumChatFormatting.GREEN, 2347852),
    YELLOW("yellow", EnumDyeColor.YELLOW, EnumChatFormatting.YELLOW, 0xFFD000),
    ORANGE("orange", EnumDyeColor.ORANGE, EnumChatFormatting.GOLD, 16749568),
    RED("red", EnumDyeColor.RED, EnumChatFormatting.RED, 15354699),
    PINK("pink", EnumDyeColor.PINK, EnumChatFormatting.LIGHT_PURPLE, 15239369),
    MAGENTA("magenta", EnumDyeColor.MAGENTA, EnumChatFormatting.LIGHT_PURPLE, 0xFF007F),
    PURPLE("purple", EnumDyeColor.PURPLE, EnumChatFormatting.DARK_PURPLE, 11748095),
    GRAY("gray", EnumDyeColor.GRAY, EnumChatFormatting.GRAY, 0xC0C0C0);

    public static final NameMap<EnumTeamColor> NAME_MAP;
    private final String name;
    private final EnumDyeColor dyeColor;
    private final EnumChatFormatting formatting;
    private final Color4I color;
    private final String langKey;

    private EnumTeamColor(String n2, EnumDyeColor d, EnumChatFormatting t, int c) {
        this.name = n2;
        this.dyeColor = d;
        this.formatting = t;
        this.color = Color4I.rgb(c);
        this.langKey = EnumDyeColorHelper.get(this.dyeColor).getLangKey();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EnumChatFormatting getEnumChatFormatting() {
        return this.formatting;
    }

    public Color4I getColor() {
        return this.color;
    }

    public EnumDyeColor getDyeColor() {
        return this.dyeColor;
    }

    public String getLangKey() {
        return this.langKey;
    }

    static {
        NAME_MAP = NameMap.createWithNameAndColor(BLUE, (sender, value) -> new ChatComponentTranslation(value.getLangKey(), new Object[0]), EnumTeamColor::getColor, EnumTeamColor.values());
    }
}

