/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.IIteratingConfig;
import serverutils.lib.icon.Color4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.util.misc.BooleanConsumer;

public class ConfigBoolean
extends ConfigValue
implements BooleanSupplier,
BooleanConsumer,
IIteratingConfig {
    public static final List<String> VARIANTS = Arrays.asList("true", "false");
    public static final String ID = "bool";
    public static final Color4I COLOR_TRUE = Color4I.rgb(0x33AA33);
    public static final Color4I COLOR_FALSE = Color4I.rgb(13969460);
    private boolean value;

    public ConfigBoolean(boolean v) {
        this.value = v;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    public void setBoolean(boolean v) {
        this.value = v;
    }

    @Override
    public String getString() {
        return this.getBoolean() ? "true" : "false";
    }

    @Override
    public int getInt() {
        return this.getBoolean() ? 1 : 0;
    }

    @Override
    public ConfigBoolean copy() {
        return new ConfigBoolean(this.getBoolean());
    }

    @Override
    public boolean equalsValue(ConfigValue value) {
        return this.getBoolean() == value.getBoolean();
    }

    @Override
    public Color4I getColor() {
        return this.getBoolean() ? COLOR_TRUE : COLOR_FALSE;
    }

    @Override
    public List<String> getVariants() {
        return VARIANTS;
    }

    @Override
    public ConfigValue getIteration(boolean next) {
        return new ConfigBoolean(!this.getBoolean());
    }

    @Override
    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        if (simulate) {
            return string.equals("true") || string.equals("false") || string.equals("toggle");
        }
        if (string.equals("toggle")) {
            this.setBoolean(!this.getBoolean());
        } else {
            this.setBoolean(string.equals("true"));
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        if (this.getBoolean()) {
            nbt.func_74757_a(key, true);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setBoolean(nbt.func_74767_n(key));
    }

    @Override
    public void writeData(DataOut data) {
        data.writeBoolean(this.getBoolean());
    }

    @Override
    public void readData(DataIn data) {
        this.setBoolean(data.readBoolean());
    }

    @Override
    public boolean getAsBoolean() {
        return this.getBoolean();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue value) {
        this.setBoolean(value.getBoolean());
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        this.setBoolean(json.getAsBoolean());
    }

    @Override
    public final void accept(boolean v) {
        this.setBoolean(v);
    }

    public static class SimpleBoolean
    extends ConfigBoolean {
        private final BooleanSupplier get;
        private final BooleanConsumer set;

        public SimpleBoolean(BooleanSupplier g, BooleanConsumer s) {
            super(false);
            this.get = g;
            this.set = s;
        }

        @Override
        public boolean getBoolean() {
            return this.get.getAsBoolean();
        }

        @Override
        public void setBoolean(boolean v) {
            this.set.accept(v);
        }
    }
}

