/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.icon.Icon;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;

public abstract class Action {
    private final ResourceLocation id;
    private IChatComponent title;
    private boolean requiresConfirm;
    private Icon icon;
    private int order;

    public Action(ResourceLocation _id, IChatComponent t, Icon i, int o) {
        this.id = _id;
        this.title = t;
        this.requiresConfirm = false;
        this.icon = i;
        this.order = o;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public abstract Type getType(ForgePlayer var1, NBTTagCompound var2);

    public abstract void onAction(ForgePlayer var1, NBTTagCompound var2);

    public Action setTitle(IChatComponent t) {
        this.title = t;
        return this;
    }

    public IChatComponent getTitle() {
        return this.title;
    }

    public Action setRequiresConfirm() {
        this.requiresConfirm = true;
        return this;
    }

    public boolean getRequireConfirm() {
        return this.requiresConfirm;
    }

    public Action setIcon(Icon i) {
        this.icon = i;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Action setOrder(int o) {
        this.order = MathHelper.func_76125_a((int)o, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        return o == this;
    }

    public final String toString() {
        return this.id.toString();
    }

    public static class Inst
    implements Comparable<Inst> {
        public static final DataOut.Serializer<Inst> SERIALIZER = (data, object) -> object.writeData(data);
        public static final DataIn.Deserializer<Inst> DESERIALIZER = Inst::new;
        public final ResourceLocation id;
        public final IChatComponent title;
        public final boolean requiresConfirm;
        public final Icon icon;
        public boolean enabled;
        public int order;

        private Inst(DataIn data) {
            this.id = data.readResourceLocation();
            this.title = data.readTextComponent();
            this.requiresConfirm = data.readBoolean();
            this.icon = data.readIcon();
            this.enabled = data.readBoolean();
            this.order = data.readVarInt();
        }

        public Inst(Action action, Type t) {
            this.id = action.getId();
            this.title = action.getTitle();
            this.requiresConfirm = action.getRequireConfirm();
            this.icon = action.getIcon();
            this.enabled = t.isEnabled();
            this.order = action.getOrder();
        }

        private void writeData(DataOut data) {
            data.writeResourceLocation(this.id);
            data.writeTextComponent(this.title);
            data.writeBoolean(this.requiresConfirm);
            data.writeIcon(this.icon);
            data.writeBoolean(this.enabled);
            data.writeVarInt(this.order);
        }

        @Override
        public int compareTo(Inst o) {
            int i = Integer.compare(this.order, o.order);
            return i == 0 ? this.title.func_150260_c().compareToIgnoreCase(o.title.func_150260_c()) : i;
        }
    }

    public static enum Type {
        ENABLED,
        DISABLED,
        INVISIBLE;


        public static Type fromBoolean(boolean value) {
            return value ? ENABLED : DISABLED;
        }

        public boolean isEnabled() {
            return this == ENABLED;
        }

        public boolean isVisible() {
            return this != INVISIBLE;
        }
    }
}

