/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.INBTSerializable;
import serverutils.lib.util.IWithID;

public class NBTDataStorage
implements INBTSerializable<NBTTagCompound>,
Consumer<Data> {
    public static final NBTDataStorage EMPTY = new NBTDataStorage(){

        @Override
        @Nullable
        public Data getRaw(String id) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        @Override
        public void deserializeNBT(NBTTagCompound nbt) {
        }
    };
    private final Map<String, Data> map = new HashMap<String, Data>();

    public void add(Data data) {
        this.map.put(data.getId(), data);
    }

    @Nullable
    public Data getRaw(String id) {
        return this.map.get(id);
    }

    public <T extends Data> T get(String id) {
        return (T)((Data)CommonUtils.cast(Objects.requireNonNull(this.getRaw(id))));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Data data : this.map.values()) {
            NBTTagCompound nbt1 = data.serializeNBT();
            if (nbt1.func_82582_d()) continue;
            nbt.func_74782_a(data.getId(), (NBTBase)nbt1);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        for (Data data : this.map.values()) {
            data.deserializeNBT(nbt.func_74775_l(data.getId()));
        }
    }

    public void clearCache() {
        for (Data data : this.map.values()) {
            data.clearCache();
        }
    }

    @Override
    public void accept(Data data) {
        this.add(data);
    }

    public static interface Data
    extends IWithID,
    INBTSerializable<NBTTagCompound> {
        @Override
        default public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        @Override
        default public void deserializeNBT(NBTTagCompound nbt) {
        }

        default public void clearCache() {
        }
    }
}

