/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import serverutils.lib.gui.Panel;
import serverutils.lib.gui.WidgetLayout;

public class CompactGridLayout
implements WidgetLayout {
    public static final int[][] LAYOUTS = new int[][]{{1}, {2}, {3}, {4}, {3, 2}, {3, 3}, {4, 3}, {4, 4}, {3, 3, 3}, {3, 4, 3}, {4, 3, 4}, {4, 4, 4}, {4, 3, 3, 3}, {3, 4, 4, 3}, {4, 4, 4, 3}, {4, 4, 4, 4}};
    public final int size;

    public CompactGridLayout(int s) {
        this.size = s;
    }

    @Override
    public int align(Panel panel) {
        int s = panel.widgets.size();
        if (s <= 0) {
            return 0;
        }
        if (s > LAYOUTS.length) {
            for (int i = 0; i < s; ++i) {
                panel.widgets.get(i).setPosAndSize(i % 4 * this.size, i / 4 * this.size, this.size, this.size);
            }
            return s / 4 * this.size;
        }
        int[] layout = LAYOUTS[s - 1];
        int m = 0;
        for (int v : layout) {
            m = Math.max(m, v);
        }
        int off = 0;
        for (int l = 0; l < layout.length; ++l) {
            int o = layout[l] % 2 == m % 2 ? 0 : this.size / 2;
            for (int i = 0; i < layout[l]; ++i) {
                panel.widgets.get(off + i).setPosAndSize(o + i * this.size, l * this.size, this.size, this.size);
            }
            off += layout[l];
        }
        return layout.length * this.size;
    }
}

