/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.icon;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import serverutils.handlers.ServerUtilitiesClientEventHandler;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.client.IPixelBuffer;
import serverutils.lib.icon.Icon;
import serverutils.lib.icon.ImageCallback;

public class IconRenderer {
    private static final Collection<IconCallbackPair> QUEUE = new LinkedList<IconCallbackPair>();
    private static Image nullImage = null;
    private static Map<Icon, Image> imageCache = new HashMap<Icon, Image>();

    public static void clearCache() {
        imageCache = new HashMap<Icon, Image>();
    }

    public static Image getNullImage() {
        if (nullImage == null) {
            try {
                nullImage = ImageIO.read(IconRenderer.class.getResourceAsStream("/assets/serverutilities/textures/icons/cancel.png"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return nullImage;
    }

    public static boolean load(@Nullable Icon icon, ImageCallback callback) {
        if (icon == null) {
            callback.imageLoaded(false, null);
            return true;
        }
        if (icon.isEmpty()) {
            callback.imageLoaded(false, IconRenderer.getNullImage());
            return true;
        }
        Image image = imageCache.get(icon);
        if (image != null) {
            callback.imageLoaded(false, image);
            return true;
        }
        if (icon.hasPixelBuffer()) {
            IPixelBuffer buffer = icon.createPixelBuffer();
            if (buffer == null) {
                image = IconRenderer.getNullImage();
            } else {
                int w = buffer.getWidth();
                int h = buffer.getHeight();
                BufferedImage image_ = new BufferedImage(w, h, 2);
                image_.setRGB(0, 0, w, h, buffer.getPixels(), 0, w);
                image = image_;
            }
            imageCache.put(icon, image);
            callback.imageLoaded(false, image);
            return true;
        }
        imageCache.put(icon, IconRenderer.getNullImage());
        callback.imageLoaded(false, IconRenderer.getNullImage());
        IconCallbackPair pair = new IconCallbackPair();
        pair.icon = icon;
        pair.callback = callback;
        Minecraft.func_71410_x().func_152344_a((Runnable)pair);
        return false;
    }

    public static void render() {
        if (QUEUE.isEmpty()) {
            return;
        }
        IconCallbackPair[] queued = QUEUE.toArray(new IconCallbackPair[0]);
        QUEUE.clear();
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int size = Math.min(Math.min(mc.field_71440_d, mc.field_71443_c), 64);
        mc.field_71460_t.func_78478_c();
        RenderHelper.func_74520_c();
        float scale = (float)size / (16.0f * (float)res.func_78325_e());
        GlStateManager.translate(0.0f, 0.0f, -(scale * 100.0f));
        GlStateManager.scale(scale, scale, scale);
        RenderItem renderItem = RenderItem.getInstance();
        float oldZLevel = renderItem.field_77023_b;
        renderItem.field_77023_b = -50.0f;
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableColorMaterial();
        GlStateManager.enableDepth();
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 770, 1);
        GlStateManager.blendFunc(770, 771);
        GlStateManager.disableAlpha();
        int[] pixels = new int[size * size];
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -size));
        BufferedImage img = new BufferedImage(size, size, 2);
        for (IconCallbackPair pair : queued) {
            GlStateManager.pushMatrix();
            GlStateManager.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
            GlStateManager.clear(16640);
            pair.icon.drawStatic(0, 0, 16, 16);
            GlStateManager.popMatrix();
            try {
                ByteBuffer buf = BufferUtils.createByteBuffer((int)(size * size * 4));
                GL11.glReadBuffer((int)1029);
                GlStateManager.glGetError();
                GL11.glReadPixels((int)0, (int)(Minecraft.func_71410_x().field_71440_d - size), (int)size, (int)size, (int)32993, (int)5121, (ByteBuffer)buf);
                buf.asIntBuffer().get(pixels);
                img.setRGB(0, 0, size, size, pixels, 0, size);
                BufferedImage flipped = new BufferedImage(size, size, 2);
                Graphics2D g = flipped.createGraphics();
                g.transform(at);
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                pixels = flipped.getRGB(0, 0, size, size, pixels, 0, size);
                BufferedImage image = new BufferedImage(size, size, 2);
                image.setRGB(0, 0, size, size, pixels, 0, size);
                imageCache.put(pair.icon, image);
                pair.callback.imageLoaded(true, image);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        GlStateManager.disableLighting();
        GlStateManager.disableColorMaterial();
        GlStateManager.disableDepth();
        GlStateManager.disableBlend();
        renderItem.field_77023_b = oldZLevel;
    }

    private static class IconCallbackPair
    implements Runnable {
        private Icon icon;
        private ImageCallback callback;

        private IconCallbackPair() {
        }

        @Override
        public void run() {
            QUEUE.add(this);
            ServerUtilitiesClientEventHandler.shouldRenderIcons = true;
        }
    }
}

