/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import serverutils.lib.ATHelper;

public class InvUtils {
    public static final int BUCKET_VOLUME = 1000;
    public static final ItemStack EMPTY_STACK = null;
    public static final IInventory EMPTY_INVENTORY = new InventoryBasic("[Null]", true, 0);
    public static final Predicate<ItemStack> NO_FILTER = stack -> true;

    public static ItemStack brokenItem(String id) {
        ItemStack stack = new ItemStack(Items.field_151115_aP);
        stack.func_151001_c("Broken Item with ID " + id);
        return stack;
    }

    @Nullable
    public static NBTTagCompound nullIfEmpty(@Nullable NBTTagCompound nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack item, int delay) {
        if (item != null) {
            EntityItem ei = new EntityItem(w, x, y, z, item.func_77946_l());
            ei.field_70159_w = mx;
            ei.field_70181_x = my;
            ei.field_70179_y = mz;
            ei.field_145804_b = delay;
            w.func_72838_d((Entity)ei);
        }
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack item, int delay) {
        InvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, item, delay);
    }

    public static void dropItem(World w, int posx, int posy, int posz, ItemStack item, int delay) {
        InvUtils.dropItem(w, (double)posx + 0.5, (double)posy + 0.5, (double)posz + 0.5, item, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        InvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void dropAllItems(World world, double x, double y, double z, Iterable<ItemStack> items) {
        if (!world.field_72995_K) {
            for (ItemStack item : items) {
                if (item == null) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static void dropAllItems(World world, double x, double y, double z, @Nullable IInventory inventory) {
        if (!world.field_72995_K && inventory != null && inventory.func_70302_i_() > 0) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack item = inventory.func_70301_a(i);
                if (item == null) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static boolean stacksAreEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77973_b() == stackB.func_77973_b() && stackA.func_77960_j() == stackB.func_77960_j() && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static Set<String> getOreNames(@Nullable Set<String> l, ItemStack is) {
        if (is == null) {
            return l == null ? Collections.emptySet() : l;
        }
        int[] ai = OreDictionary.getOreIDs((ItemStack)is);
        if (ai.length > 0) {
            if (l == null) {
                l = new HashSet<String>(ai.length);
            }
            for (int i : ai) {
                l.add(OreDictionary.getOreName((int)i));
            }
            return l;
        }
        return Collections.emptySet();
    }

    public static int[] getPlayerSlots(EntityPlayer player) {
        return IntStream.range(0, player.field_71071_by.field_70462_a.length).toArray();
    }

    public static ItemStack singleCopy(ItemStack is) {
        if (is.field_77994_a <= 0) {
            return null;
        }
        ItemStack is1 = is.func_77946_l();
        is1.field_77994_a = 1;
        return is1;
    }

    public static boolean addSingleItemToInv(ItemStack is, IInventory inv, int[] slots, boolean doAdd) {
        ItemStack is1;
        ItemStack single = InvUtils.singleCopy(is);
        if (single == null) {
            return false;
        }
        for (int slot : slots) {
            is1 = inv.func_70301_a(slot);
            if (is1 == null || is1.field_77994_a <= 0 || !InvUtils.stacksAreEqual(is, is1) || is1.field_77994_a + 1 > is1.func_77976_d()) continue;
            if (doAdd) {
                ++is1.field_77994_a;
                inv.func_70299_a(slot, is1);
                inv.func_70296_d();
            }
            return true;
        }
        for (int slot2 : slots) {
            is1 = inv.func_70301_a(slot2);
            if (is1 != null && is1.field_77994_a != 0) continue;
            if (doAdd) {
                inv.func_70299_a(slot2, single);
                inv.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public static void giveItem(EntityPlayer player, ItemStack item) {
        if (player.field_71071_by == null || item.field_77994_a <= 0) {
            return;
        }
        ItemStack is = item.func_77946_l();
        boolean changed = false;
        int size = is.field_77994_a;
        for (int i = 0; i < size; ++i) {
            if (!InvUtils.addSingleItemToInv(is, (IInventory)player.field_71071_by, InvUtils.getPlayerSlots(player), true)) continue;
            --is.field_77994_a;
            changed = true;
        }
        if (changed) {
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
        if (is.field_77994_a > 0) {
            InvUtils.dropItem((Entity)player, is);
        }
    }

    public static void giveItemFromIterable(EntityPlayer player, Iterable<ItemStack> items) {
        for (ItemStack item : items) {
            if (item == null) continue;
            InvUtils.giveItem(player, item);
        }
    }

    public static void forceUpdate(Container container) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)container.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = itemstack == null ? EMPTY_STACK : itemstack.func_77946_l();
            container.field_75153_a.set(i, itemstack1);
            for (ICrafting listener : ATHelper.getContainerListeners(container)) {
                listener.func_71111_a(container, i, itemstack1);
            }
        }
    }

    public static void forceUpdate(EntityPlayer player) {
        InvUtils.forceUpdate(player.field_71069_bz);
    }

    public static boolean clear(IInventory inv) {
        if (inv == null) {
            return false;
        }
        boolean hadItems = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = InvUtils.removeStackFromSlot(inv, i);
            if (hadItems || is == null || is.field_77994_a <= 0) continue;
            hadItems = true;
        }
        if (hadItems) {
            inv.func_70296_d();
        }
        return hadItems;
    }

    public static ItemStack removeStackFromSlot(IInventory inv, int i) {
        if (inv == null) {
            return null;
        }
        ItemStack is = inv.func_70301_a(i);
        if (is != null) {
            inv.func_70299_a(i, null);
            return is.field_77994_a > 0 ? is : null;
        }
        return null;
    }
}

