/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.util.compression;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.compression.CommonsCompressor;
import serverutils.lib.util.compression.LegacyCompressor;

public interface ICompress
extends AutoCloseable {
    public static final boolean useLegacy = !CommonUtils.getClassExists("org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream");

    public void createOutputStream(File var1) throws IOException;

    public void addFileToArchive(File var1, String var2) throws IOException;

    public void extractArchive(File var1, boolean var2, boolean var3) throws IOException;

    public boolean isOldBackup(File var1) throws IOException;

    @Nullable
    public String getWorldName(File var1) throws IOException;

    public static ICompress createCompressor() {
        return useLegacy ? new LegacyCompressor() : new CommonsCompressor();
    }
}

