/*
 * Decompiled with CFR 0.152.
 */
package serverutils.mixins.early.minecraft.vanish;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.server.CommandListPlayers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.EnumChatFormatting;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import serverutils.lib.data.Universe;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringJoiner;
import serverutils.lib.util.permission.PermissionAPI;

@Mixin(value={CommandListPlayers.class})
public abstract class MixinCommandListPlayers {
    @Redirect(method={"processCommand"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/ServerConfigurationManager;func_152609_b(Z)Ljava/lang/String;"))
    private String serverutilities$removeVanishedPlayers(ServerConfigurationManager instance, boolean includeUuid, @Local(argsOnly=true) ICommandSender sender) {
        EntityPlayerMP playerMP;
        boolean canSeeVanish;
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>(instance.field_72404_b);
        boolean bl = canSeeVanish = !(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)(playerMP = (EntityPlayerMP)sender), "serverutilities.vanish.see");
        if (!canSeeVanish) {
            players.removeIf(ServerUtils::isVanished);
        }
        return StringJoiner.with(", ").join(players, player -> {
            String playerName = player.func_70005_c_();
            if (canSeeVanish && ServerUtils.isVanished((Entity)player)) {
                playerName = "[V] " + EnumChatFormatting.STRIKETHROUGH + playerName + EnumChatFormatting.RESET;
            }
            if (includeUuid) {
                playerName = playerName + " (" + player.func_110124_au().toString() + ")";
            }
            return playerName;
        });
    }

    @ModifyExpressionValue(method={"processCommand"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCurrentPlayerCount()I")})
    private int serverutilities$removeVanishedPlayers(int original, @Local(argsOnly=true) ICommandSender sender) {
        EntityPlayerMP playerMP;
        if (!(sender instanceof EntityPlayerMP) || PermissionAPI.hasPermission((EntityPlayer)(playerMP = (EntityPlayerMP)sender), "serverutilities.vanish.see")) {
            return original + Universe.get().getVanishedPlayers().size();
        }
        return original;
    }
}

