/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayDeque;
import net.minecraft.entity.EntityLiving;
import toast.specialMobs.ReplacementEntry;
import toast.specialMobs._SpecialMobs;

public class TickHandler {
    public static ArrayDeque<ReplacementEntry> entityStack = new ArrayDeque();
    private long lastStackTrimmedMessageTime = 0L;

    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !entityStack.isEmpty()) {
            ReplacementEntry entry;
            int limit = 10;
            while (limit-- > 0 && (entry = entityStack.pollFirst()) != null) {
                entry.replace();
            }
            if (entityStack.size() > 12000) {
                long now = System.currentTimeMillis();
                if (Math.abs(now - this.lastStackTrimmedMessageTime) > 10000L) {
                    _SpecialMobs.console("Entity transformation list reached a size of " + entityStack.size() + ", force-clearing.");
                    this.lastStackTrimmedMessageTime = now;
                }
                entityStack.clear();
            }
        }
    }

    public static void markEntityToBeReplaced(EntityLiving entity) {
        entityStack.add(new ReplacementEntry(entity));
    }
}

