/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.ghast;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import toast.specialMobs.MobHelper;
import toast.specialMobs.entity.ghast.Entity_SpecialGhast;

public class EntityMountGhast
extends Entity_SpecialGhast {
    public EntityLiving targetedRider;
    public boolean prevInRange;
    private Entity lastRiddenByEntity;
    private boolean riderIsRanged;

    public EntityMountGhast(World world) {
        super(world);
    }

    @Override
    protected void updateEntityGoal() {
        double reach;
        this.updateEntityTarget();
        float distanceSq = Float.POSITIVE_INFINITY;
        if (this.field_70792_g != null) {
            distanceSq = (float)this.field_70792_g.func_70068_e((Entity)this);
        }
        boolean inRange = false;
        if (this.field_70153_n != null) {
            if (this.field_70153_n.func_70089_S() && this.field_70792_g != null && this.isRiderRanged()) {
                inRange = (double)distanceSq < 64.0;
            }
            this.targetedRider = null;
        } else if (!(this.field_70792_g != null || this.targetedRider != null && this.targetedRider.field_70154_o == null && this.targetedRider.func_70089_S() || this.field_70146_Z.nextInt(100) != 0)) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(100.0, 100.0, 100.0));
            double closestDistance = Double.POSITIVE_INFINITY;
            for (int i = 0; i < list.size(); ++i) {
                double distance;
                EntityLiving entity;
                if (!(list.get(i) instanceof EntityLiving) || !((entity = (EntityLiving)list.get(i)) instanceof IMob) || entity instanceof EntityFlying || entity.field_70154_o != null || entity.field_70153_n != null || entity == this.field_70792_g || !this.func_70635_at().func_75522_a((Entity)entity) || !((distance = entity.func_70068_e((Entity)this)) < closestDistance)) continue;
                this.targetedRider = entity;
                closestDistance = distance;
            }
        }
        double vX = this.field_70795_b - this.field_70165_t;
        double vY = this.field_70796_c - this.field_70163_u;
        double vZ = this.field_70793_d - this.field_70161_v;
        double v = vX * vX + vY * vY + vZ * vZ;
        if (v < 0.1 || v > 3600.0 || inRange != this.prevInRange) {
            if (inRange) {
                this.setRandomWaypoints(4.0f);
            } else if (this.targetedRider != null) {
                this.field_70795_b = this.targetedRider.field_70165_t;
                this.field_70796_c = this.targetedRider.field_70163_u + (double)(this.targetedRider.field_70131_O / 2.0f);
                this.field_70793_d = this.targetedRider.field_70161_v;
                if (!this.isCourseTraversable(Math.sqrt(v))) {
                    this.setRandomWaypoints(32.0f);
                }
            } else if (this.field_70792_g != null) {
                this.field_70795_b = this.field_70792_g.field_70165_t;
                this.field_70796_c = this.field_70792_g.field_70163_u + (double)(this.field_70792_g.field_70131_O / 2.0f);
                this.field_70793_d = this.field_70792_g.field_70161_v;
                if (!this.isCourseTraversable(Math.sqrt(v))) {
                    this.setRandomWaypoints(32.0f);
                }
            } else {
                this.setRandomWaypoints(32.0f);
                this.field_70796_c = Math.max(this.field_70796_c, Math.max(70.0, (double)this.field_70170_p.func_72976_f((int)Math.floor(this.field_70795_b), (int)Math.floor(this.field_70793_d)) + 16.0));
            }
        }
        if (this.field_70797_a-- <= 0) {
            this.field_70797_a += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(v = Math.sqrt(v))) {
                double speed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() / v;
                if (this.field_70792_g == null && this.targetedRider == null) {
                    speed *= 0.3;
                }
                this.field_70159_w += vX * speed;
                this.field_70181_x += vY * speed;
                this.field_70179_y += vZ * speed;
            } else {
                this.setRandomWaypoints(8.0f);
            }
        }
        if (this.field_70791_f > 0) {
            --this.field_70791_f;
        }
        if (this.targetedRider != null) {
            this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.targetedRider.field_70165_t - this.field_70165_t, this.targetedRider.field_70161_v - this.field_70161_v) * -180.0f / (float)Math.PI;
            reach = this.field_70130_N * this.field_70130_N * 4.0f + this.targetedRider.field_70130_N;
            if (this.func_70092_e(this.targetedRider.field_70165_t, this.targetedRider.field_70163_u + (double)(this.targetedRider.field_70131_O / 2.0f), this.targetedRider.field_70161_v) <= reach) {
                this.targetedRider.func_70078_a((Entity)this);
                this.targetedRider = null;
            }
        } else if (this.field_70792_g != null) {
            this.field_70761_aq = this.field_70177_z = (float)Math.atan2(this.field_70792_g.field_70165_t - this.field_70165_t, this.field_70792_g.field_70161_v - this.field_70161_v) * -180.0f / (float)Math.PI;
            if (this.field_70791_f <= 0) {
                reach = this.field_70130_N * this.field_70130_N * 4.0f + this.field_70792_g.field_70130_N;
                if (this.func_70092_e(this.field_70792_g.field_70165_t, this.field_70792_g.field_70163_u + (double)(this.field_70792_g.field_70131_O / 2.0f), this.field_70792_g.field_70161_v) <= reach) {
                    this.field_70791_f = 20;
                    this.func_71038_i();
                    this.func_70652_k(this.field_70792_g);
                }
            }
            if (this.field_70153_n instanceof EntityLiving) {
                if (this.field_70792_g instanceof EntityLivingBase) {
                    ((EntityLiving)this.field_70153_n).func_70624_b((EntityLivingBase)this.field_70792_g);
                }
                if (this.field_70153_n instanceof EntityCreature) {
                    ((EntityCreature)this.field_70153_n).func_70784_b(this.field_70792_g);
                }
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
        this.prevInRange = inRange;
    }

    @Override
    protected void updateEntityTarget() {
        if (this.field_70792_g != null && this.field_70792_g.field_70128_L) {
            this.field_70792_g = null;
        }
        if (this.field_70792_g == null || this.field_70798_h-- <= 0) {
            double dZ;
            double dX;
            this.field_70792_g = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.field_70792_g != null && this.field_71093_bK == 0 && (dX = this.field_70792_g.field_70165_t - this.field_70165_t) * dX + (dZ = this.field_70792_g.field_70161_v - this.field_70161_v) * dZ > 256.0) {
                this.field_70792_g = null;
            }
            if (this.field_70792_g != null) {
                this.field_70798_h = 20;
            }
        }
        if (!(this.targetedRider == null || this.targetedRider.field_70154_o == null && this.targetedRider.field_70153_n == null && this.targetedRider.func_70089_S())) {
            this.targetedRider = null;
        }
    }

    public boolean isRiderRanged() {
        if (this.lastRiddenByEntity != this.field_70153_n) {
            this.riderIsRanged = this.field_70153_n instanceof EntityLiving && MobHelper.hasRangedAttack((EntityLiving)this.field_70153_n);
            this.lastRiddenByEntity = this.field_70153_n;
        }
        return this.riderIsRanged;
    }

    @Override
    public boolean isCourseTraversable(double v) {
        int i;
        AxisAlignedBB aabb;
        double dX = (this.field_70795_b - this.field_70165_t) / v;
        double dY = (this.field_70796_c - this.field_70163_u) / v;
        double dZ = (this.field_70793_d - this.field_70161_v) / v;
        if (this.field_70153_n != null && this.field_70153_n.func_70089_S()) {
            aabb = this.field_70153_n.field_70121_D.func_72329_c();
            i = 1;
            while ((double)i < v) {
                aabb.func_72317_d(dX, dY, dZ);
                if (!this.field_70170_p.func_72945_a(this.field_70153_n, aabb).isEmpty()) {
                    return false;
                }
                ++i;
            }
        }
        aabb = this.field_70121_D.func_72329_c();
        i = 1;
        while ((double)i < v) {
            aabb.func_72317_d(dX, dY, dZ);
            if (!this.field_70170_p.func_72945_a((Entity)this, aabb).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

