/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.spider;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.EffectHelper;
import toast.specialMobs.MobHelper;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.spider.Entity_SpecialSpider;

public class EntityHungrySpider
extends Entity_SpecialSpider {
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/hungry.png"), new ResourceLocation(_SpecialMobs.TEXTURE_PATH + "spider/hungry_eyes.png")};
    private byte feedingLevel;
    private int gainedHealth;
    private final ArrayList<ItemStack> stomach = new ArrayList();

    public EntityHungrySpider(World world) {
        super(world);
        this.getSpecialData().setTextures(TEXTURES);
        this.getSpecialData().resetRenderScale(0.8f);
        this.field_70728_aV += 4;
    }

    @Override
    public void adjustTypeAttributes() {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, -1.0);
        this.getSpecialData().setHealTime(40);
        this.getSpecialData().arrowRange = 0.0f;
        this.func_98053_h(true);
    }

    @Override
    public void onTypeAttack(Entity target) {
        ItemStack drop;
        if (target instanceof EntityPlayer && (drop = MobHelper.removeRandomItem((EntityPlayer)target)) != null) {
            if (this.func_98052_bS()) {
                this.func_70062_b(0, drop);
            } else {
                this.func_70099_a(drop, 0.0f);
                this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void func_70062_b(int slot, ItemStack itemStack) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (itemStack != null && this.gainedHealth < 64) {
            ++this.gainedHealth;
            float maxHealth = this.func_110138_aP();
            this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 4.0);
            this.func_70606_j(this.func_110143_aJ() + this.func_110138_aP() - maxHealth);
            if (this.feedingLevel < 7) {
                this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111264_e, 1.0);
                this.getSpecialData().arrowDamage += 0.5f;
            }
            this.setFeedingLevel(this.feedingLevel + 1, true);
        }
        if (this.gainedHealth >= 64) {
            this.func_98053_h(false);
        }
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemFood) {
                this.func_70691_i(((ItemFood)itemStack.func_77973_b()).func_150905_g(itemStack));
            } else {
                this.stomach.add(itemStack);
            }
            this.field_70170_p.func_72956_a((Entity)this, "random.burp", 0.5f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
        if (hit && (this.field_70146_Z.nextInt(3) == 0 || this.field_70146_Z.nextInt(1 + looting) > 0)) {
            this.func_145779_a(Items.field_151034_e, 1);
        }
        for (ItemStack itemStack : this.stomach) {
            this.func_70099_a(itemStack, 0.0f);
        }
        this.stomach.clear();
    }

    protected void func_70600_l(int superRare) {
        ItemStack itemStack = new ItemStack((Item)Items.field_151068_bn, 1, 8196);
        EffectHelper.setItemName(itemStack, "Potion of Hunger", 15);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76420_g, 1200, 0);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76428_l, 1200, 0);
        EffectHelper.addPotionEffect(itemStack, Potion.field_76438_s, 600, 1);
        this.func_70099_a(itemStack, 0.0f);
    }

    private void setFeedingLevel(int level, boolean updateScale) {
        if (level < 0) {
            level = 0;
        } else if (level > 7) {
            level = 7;
        }
        int diff = level - this.feedingLevel;
        if (diff != 0) {
            this.feedingLevel = (byte)level;
            this.func_70105_a(1.0f + 0.12857f * (float)level, 0.8f + 0.07142f * (float)level);
            if (updateScale) {
                this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + 0.1f * (float)diff);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("FeedLevel", this.feedingLevel);
        tag.func_74774_a("GrowCount", (byte)this.gainedHealth);
        NBTTagList tagList = new NBTTagList();
        for (ItemStack itemStack : this.stomach) {
            NBTTagCompound tagItem = new NBTTagCompound();
            itemStack.func_77955_b(tagItem);
            tagList.func_74742_a((NBTBase)tagItem);
        }
        tag.func_74782_a("Stomach", (NBTBase)tagList);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("FeedLevel")) {
            this.setFeedingLevel(tag.func_74771_c("FeedLevel"), false);
        }
        if (tag.func_74764_b("GrowCount")) {
            this.gainedHealth = tag.func_74771_c("GrowCount") & 0xFF;
        }
        if (tag.func_74764_b("Stomach")) {
            NBTTagList tagList = tag.func_150295_c("Stomach", (int)new NBTTagCompound().func_74732_a());
            this.stomach.clear();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.stomach.add(ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i)));
            }
        }
    }
}

