/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Computer;

import vswe.stevescarts.Computer.IWriting;
import vswe.stevescarts.Modules.Workers.ModuleComputer;

public class ComputerVar
implements IWriting {
    private ModuleComputer module;
    private short info;
    private short val;
    private String name = "??????";
    private static final String validChars = "? ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public ComputerVar(ModuleComputer module) {
        this.module = module;
    }

    @Override
    public String getText() {
        return this.name.replace("?", "");
    }

    @Override
    public int getMaxLength() {
        return 6;
    }

    @Override
    public void addChar(char c) {
        this.name = this.name.replace("?", "");
        this.name = this.name + c;
        while (this.name.length() < this.getMaxLength()) {
            this.name = this.name + "?";
        }
    }

    @Override
    public void removeChar() {
        this.name = this.name.replace("?", "");
        this.name = this.name.substring(0, this.name.length() - 1);
        while (this.name.length() < this.getMaxLength()) {
            this.name = this.name + "?";
        }
    }

    public int getByteValue() {
        byte val = (byte)(this.val & 0xFF);
        return val;
    }

    public void setByteValue(int val) {
        if (val < -128) {
            val = -128;
        } else if (val > 127) {
            val = 127;
        }
        if (val < 0) {
            val += 256;
        }
        this.val = (short)val;
    }

    public String getFullInfo() {
        return this.getText() + " = " + this.getByteValue();
    }

    public boolean isEditing() {
        return (this.info & 1) != 0;
    }

    public void setEditing(boolean val) {
        this.info = (short)(this.info & 0xFFFFFFFE);
        this.info = (short)(this.info | (val ? (short)1 : 0));
        if (val) {
            this.module.setWriting(this);
        } else if (this.module.getWriting() == this) {
            this.module.setWriting(null);
        }
    }

    public void setInfo(int id, short val) {
        if (id == 0) {
            this.info = val;
            this.setEditing(this.isEditing());
        } else if (id == 1) {
            this.val = val;
        } else {
            byte char1 = (byte)((val & 0xFF00) >> 8);
            byte char2 = (byte)(val & 0xFF);
            this.name = this.name.substring(0, (id -= 2) * 2) + this.getChar(char1) + this.getChar(char2) + this.name.substring(id * 2 + 2);
        }
    }

    private char getChar(int index) {
        if (index < 0) {
            index += 256;
        }
        if (index >= validChars.length()) {
            index = 0;
        }
        return validChars.charAt(index);
    }

    public short getInfo(int id) {
        if (id == 0) {
            return this.info;
        }
        if (id == 1) {
            return this.val;
        }
        int char1 = this.getCode(this.name.charAt((id -= 2) * 2));
        int char2 = this.getCode(this.name.charAt(id * 2 + 1));
        return (short)(char1 << 8 | char2);
    }

    private int getCode(char c) {
        int index = validChars.indexOf(c);
        if (index == -1) {
            index = 0;
        }
        return index;
    }
}

