/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Fancy;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.StringUtils;
import vswe.stevescarts.Fancy.ANIMATION_TYPE;
import vswe.stevescarts.Fancy.FancyPancyHandler;
import vswe.stevescarts.Fancy.LOAD_TYPE;

@SideOnly(value=Side.CLIENT)
public class FancyPancy {
    private FancyPancyHandler fancyPancyHandler;
    public int priority = 0;
    private String[] images;
    private int currentImage = 0;
    private EnumSet<ANIMATION_TYPE> types;
    private int interval = 50;
    private int intervalWait = 200;
    private int ticks;
    private String[] servers;
    private boolean hasServerBlackList;
    private LOAD_TYPE loadType;
    private List<SpecialLoadSetting> loadPixelSettings;
    private String[] teams;
    private List<int[]> dimensions;
    private List<long[]> times;
    private boolean useLocalTime = true;
    private String[] observers;
    private boolean hasObserverBlacklist;
    private String[] observerTeams;

    public FancyPancy(FancyPancyHandler fancyPancyHandler, HashMap<String, String[]> entries) {
        this.fancyPancyHandler = fancyPancyHandler;
        this.addImages(entries.get("Image"));
        this.setTypes(entries.get("Animation"));
        this.setInterval(entries.get("Interval"));
        this.setPriority(entries.get("Priority"));
        this.setServers(entries.get("Server"), entries.get("Blocked"));
        this.setLoad(entries.get("Load"));
        this.setTeams(entries.get("Team"));
        this.setDimensions(entries.get("World"));
        this.setTimes(entries.get("Time"));
        this.setTimeMode(entries.get("Zone"));
        this.setObservers(entries.get("Observer"), entries.get("BlockedObserver"), entries.get("ObserverTeam"));
        this.loadType = fancyPancyHandler.getDefaultLoadType();
    }

    private void setObservers(String[] observers, String[] blockedObservers, String[] observerTeams) {
        if (observers != null && observers.length > 0) {
            this.observers = observers;
            this.hasObserverBlacklist = false;
        } else if (blockedObservers != null && blockedObservers.length > 0) {
            this.observers = blockedObservers;
            this.hasObserverBlacklist = true;
        }
        this.observerTeams = observerTeams;
    }

    private void setTimeMode(String[] zones) {
        if (zones != null && zones.length > 0) {
            if (zones[0].equals("Local")) {
                this.useLocalTime = true;
            } else if (zones[0].equals("GMT")) {
                this.useLocalTime = false;
            }
        }
    }

    public void setTimes(String[] times) {
        if (times != null) {
            this.times = new ArrayList<long[]>();
            for (String level : times) {
                String[] split = level.split(";");
                if (split.length != 2) continue;
                try {
                    long[] result = new long[split.length];
                    for (int i = 0; i < split.length; ++i) {
                        result[i] = Long.parseLong(split[i]);
                    }
                    this.times.add(result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.times.size() == 0) {
                this.times = null;
            }
        }
    }

    public void setDimensions(String[] dimensions) {
        if (dimensions != null) {
            this.dimensions = new ArrayList<int[]>();
            for (String dimension : dimensions) {
                String[] split = dimension.split(";");
                if (split.length != 1 && split.length != 2) continue;
                try {
                    int[] result = new int[split.length];
                    for (int i = 0; i < split.length; ++i) {
                        result[i] = Integer.parseInt(split[i].trim());
                    }
                    this.dimensions.add(result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.dimensions.size() == 0) {
                this.dimensions = null;
            }
        }
    }

    public void update() {
        if (this.types.contains((Object)ANIMATION_TYPE.PAUSE) && this.currentImage == this.images.length - 1 && this.intervalWait >= 0) {
            if (++this.ticks >= this.intervalWait) {
                this.ticks = 0;
                this.nextImage();
            }
        } else if (!this.types.contains((Object)ANIMATION_TYPE.STILL) && this.interval >= 0 && ++this.ticks >= this.interval) {
            this.ticks = 0;
            this.nextImage();
        }
    }

    private void setTypes(String[] typeStrings) {
        this.types = EnumSet.noneOf(ANIMATION_TYPE.class);
        if (typeStrings != null) {
            block0: for (String typeString : typeStrings) {
                for (ANIMATION_TYPE animation : ANIMATION_TYPE.values()) {
                    if (!animation.getCode().equals(typeString)) continue;
                    this.types.add(animation);
                    continue block0;
                }
            }
        }
        if (this.types.size() == 0) {
            this.types.add(ANIMATION_TYPE.STILL);
        } else if (this.types.contains((Object)ANIMATION_TYPE.RANDOM)) {
            this.nextImage();
        }
    }

    private void nextImage() {
        this.currentImage = this.types.contains((Object)ANIMATION_TYPE.RANDOM) ? (int)(Math.random() * (double)this.images.length) : (this.currentImage + 1) % this.images.length;
    }

    public String getImage() {
        if (this.images == null) {
            return null;
        }
        return this.images[this.currentImage];
    }

    public void setInterval(String[] intervals) {
        if (intervals != null && intervals.length >= 1) {
            try {
                this.interval = Integer.parseInt(intervals[0]);
                if (intervals.length >= 2) {
                    this.intervalWait = Integer.parseInt(intervals[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addImages(String[] images) {
        if (images != null) {
            this.images = new String[images.length];
            for (int i = 0; i < images.length; ++i) {
                String image = images[i];
                if (image.startsWith("^")) {
                    image = image.substring(1);
                } else if (image.startsWith("*")) {
                    String defaultPath = this.fancyPancyHandler.getDefaultUrl();
                    if (defaultPath == null) {
                        defaultPath = "https://dl.dropbox.com/u/46486053/";
                    }
                    image = defaultPath + image.substring(1) + ".png";
                } else {
                    image = "https://dl.dropbox.com/u/46486053/" + image + ".png";
                }
                this.images[i] = image;
            }
        }
    }

    public void setPriority(String[] priorities) {
        if (priorities != null) {
            try {
                this.priority = Integer.parseInt(priorities[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setServers(String[] serversWhiteList, String[] serversBlackList) {
        if (serversWhiteList != null && serversWhiteList.length > 0) {
            this.servers = serversWhiteList;
            this.hasServerBlackList = false;
        } else if (serversBlackList != null && serversBlackList.length > 0) {
            this.servers = serversBlackList;
            this.hasServerBlackList = true;
        }
    }

    public boolean isValid(AbstractClientPlayer player, boolean hasMojangFancy, boolean usingMojangFancy) {
        if (!this.isObserverValid()) {
            return false;
        }
        if (!this.isServerValid()) {
            return false;
        }
        if (!this.isTimeValid()) {
            return false;
        }
        if (!this.isTeamValid(player)) {
            return false;
        }
        if (!this.isDimensionValid(player)) {
            return false;
        }
        if (hasMojangFancy && !usingMojangFancy && this.loadPixelSettings != null) {
            return false;
        }
        boolean specialCheck = this.loadPixelSettings == null || usingMojangFancy && this.doSpecialCheck(player);
        switch (this.loadType) {
            case KEEP: {
                return !hasMojangFancy || !specialCheck;
            }
            case OVERRIDE: {
                return !hasMojangFancy || specialCheck;
            }
            case REQUIRE: {
                return hasMojangFancy && specialCheck;
            }
        }
        return false;
    }

    private boolean isObserverValid() {
        EntityClientPlayerMP observerPlayer = Minecraft.func_71410_x().field_71439_g;
        String observerName = StringUtils.func_76338_a((String)observerPlayer.getDisplayName());
        if (this.observers != null && this.observers.length != 0) {
            boolean foundObserver = false;
            for (String observer : this.observers) {
                if (!observer.equals(observerName)) continue;
                foundObserver = true;
                break;
            }
            if (this.hasObserverBlacklist == foundObserver) {
                return false;
            }
        }
        return this.isTeamValid((AbstractClientPlayer)observerPlayer, this.observerTeams);
    }

    private boolean isTimeValid() {
        if (this.times == null) {
            return true;
        }
        Calendar calendar = this.useLocalTime ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        long now = (calendar.getTimeInMillis() + (long)calendar.getTimeZone().getOffset(calendar.getTimeInMillis())) / 1000L;
        for (long[] time : this.times) {
            if (time[0] > now || now > time[1]) continue;
            return true;
        }
        return false;
    }

    private boolean isDimensionValid(AbstractClientPlayer player) {
        if (this.dimensions == null || this.dimensions.size() == 0) {
            return true;
        }
        if (player.field_70170_p == null || player.field_70170_p.field_73011_w == null) {
            return false;
        }
        int id = player.field_70170_p.field_73011_w.field_76574_g;
        for (int[] levelRange : this.dimensions) {
            if ((levelRange.length != 1 || levelRange[0] != id) && (levelRange.length != 2 || levelRange[0] > id || id > levelRange[1])) continue;
            return true;
        }
        return false;
    }

    private boolean isTeamValid(AbstractClientPlayer player) {
        return this.isTeamValid(player, this.teams);
    }

    private boolean isTeamValid(AbstractClientPlayer player, String[] teams) {
        if (teams == null || teams.length == 0) {
            return true;
        }
        Team team = player.func_96124_cp();
        String requiredTeam = team == null ? "~" : team.func_96661_b();
        for (String teamName : teams) {
            if (!teamName.equals(requiredTeam)) continue;
            return true;
        }
        return false;
    }

    private boolean doSpecialCheck(AbstractClientPlayer player) {
        ThreadDownloadImageData data = this.fancyPancyHandler.getCurrentTexture(player);
        if (data == null) {
            return false;
        }
        BufferedImage image = (BufferedImage)ReflectionHelper.getPrivateValue(ThreadDownloadImageData.class, (Object)data, (int)2);
        if (image != null) {
            for (SpecialLoadSetting loadPixelSetting : this.loadPixelSettings) {
                int color = image.getRGB(loadPixelSetting.x, loadPixelSetting.y);
                int R = color >>> 16 & 0xFF;
                int G = color >>> 8 & 0xFF;
                int B = color & 0xFF;
                if (R != loadPixelSetting.r || G != loadPixelSetting.g || B != loadPixelSetting.b) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isServerValid() {
        if (this.servers == null) {
            return true;
        }
        for (String server : this.servers) {
            if (!server.equals(this.fancyPancyHandler.getServerHash())) continue;
            return !this.hasServerBlackList;
        }
        return this.hasServerBlackList;
    }

    public void setLoad(String[] loadSettings) {
        if (loadSettings != null && loadSettings.length > 0) {
            String loadTypeString = loadSettings[0];
            for (LOAD_TYPE load : LOAD_TYPE.values()) {
                if (!load.getCode().equals(loadTypeString)) continue;
                this.loadType = load;
                break;
            }
            if (loadSettings.length > 1) {
                this.loadPixelSettings = new ArrayList<SpecialLoadSetting>();
                for (int i = 1; i < loadSettings.length; ++i) {
                    String setting = loadSettings[i];
                    String[] split = setting.split(";");
                    if (split.length != 5) continue;
                    try {
                        SpecialLoadSetting special = new SpecialLoadSetting();
                        special.x = Integer.parseInt(split[0].trim());
                        special.y = Integer.parseInt(split[1].trim());
                        special.r = Integer.parseInt(split[2].trim());
                        special.g = Integer.parseInt(split[3].trim());
                        special.b = Integer.parseInt(split[4].trim());
                        this.loadPixelSettings.add(special);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.loadPixelSettings.size() == 0) {
                    this.loadPixelSettings = null;
                }
            }
        }
    }

    public void setTeams(String[] teams) {
        this.teams = teams;
    }

    private class SpecialLoadSetting {
        private int x;
        private int y;
        private int r;
        private int g;
        private int b;

        private SpecialLoadSetting() {
        }
    }
}

