/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Containers.ContainerActivator;
import vswe.stevescarts.Containers.ContainerBase;
import vswe.stevescarts.Helpers.ActivatorOption;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Interfaces.GuiActivator;
import vswe.stevescarts.Interfaces.GuiBase;
import vswe.stevescarts.Modules.Addons.ModuleChunkLoader;
import vswe.stevescarts.Modules.Addons.ModuleInvisible;
import vswe.stevescarts.Modules.Addons.ModuleShield;
import vswe.stevescarts.Modules.Realtimers.ModuleCage;
import vswe.stevescarts.Modules.Workers.Tools.ModuleDrill;
import vswe.stevescarts.TileEntities.TileEntityBase;

public class TileEntityActivator
extends TileEntityBase {
    private ArrayList<ActivatorOption> options;

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiActivator(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerActivator((IInventory)inv, this);
    }

    public TileEntityActivator() {
        this.loadOptions();
    }

    private void loadOptions() {
        this.options = new ArrayList();
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_DRILL, ModuleDrill.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_SHIELD, ModuleShield.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_INVISIBILITY, ModuleInvisible.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CHUNK, ModuleChunkLoader.class));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE_AUTO, ModuleCage.class, 0));
        this.options.add(new ActivatorOption(Localization.GUI.TOGGLER.OPTION_CAGE, ModuleCage.class, 1));
    }

    public ArrayList<ActivatorOption> getOptions() {
        return this.options;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        for (ActivatorOption option : this.options) {
            option.setOption(nbttagcompound.func_74771_c(option.getName()));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        for (ActivatorOption option : this.options) {
            nbttagcompound.func_74774_a(option.getName(), (byte)option.getOption());
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            boolean leftClick = (data[0] & 1) == 0;
            int optionId = (data[0] & 0xFFFFFFFE) >> 1;
            if (optionId >= 0 && optionId < this.options.size()) {
                this.options.get(optionId).changeOption(leftClick);
            }
        }
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
        for (int i = 0; i < this.options.size(); ++i) {
            this.updateGuiData(con, crafting, i, (short)this.options.get(i).getOption());
        }
    }

    @Override
    public void checkGuiData(Container con, ICrafting crafting) {
        for (int i = 0; i < this.options.size(); ++i) {
            int lastoption;
            int option = this.options.get(i).getOption();
            if (option == (lastoption = ((ContainerActivator)con).lastOptions.get(i).intValue())) continue;
            this.updateGuiData(con, crafting, i, (short)option);
            ((ContainerActivator)con).lastOptions.set(i, option);
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id >= 0 && id < this.options.size()) {
            this.options.get(id).setOption(data);
        }
    }

    public void handleCart(MinecartModular cart, boolean isOrange) {
        for (ActivatorOption option : this.options) {
            if (option.isDisabled()) continue;
            cart.handleActivator(option, isOrange);
        }
    }
}

