/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.util.RenderHelperAO;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperLL;
import com.jaquadro.minecraft.storagedrawers.util.RenderHelperState;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static final int YNEG = 0;
    public static final int YPOS = 1;
    public static final int ZNEG = 2;
    public static final int ZPOS = 3;
    public static final int XNEG = 4;
    public static final int XPOS = 5;
    public static final int FULL_BRIGHTNESS = 0xF000F0;
    private static final float[][] normMap = new float[][]{{0.0f, -1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}, {-1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}};
    public RenderHelperState state = new RenderHelperState();
    private RenderHelperAO aoHelper = new RenderHelperAO(this.state);
    private RenderHelperLL llHelper = new RenderHelperLL(this.state);
    private float[] colorScratch = new float[3];
    public static final ThreadLocal<RenderHelper> instances = ThreadLocal.withInitial(RenderHelper::new);

    public static void calculateBaseColor(float[] target, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float gray = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float rg = (r * 30.0f + g * 70.0f) / 100.0f;
            float rb = (r * 30.0f + b * 70.0f) / 100.0f;
            r = gray;
            g = rg;
            b = rb;
        }
        target[0] = r;
        target[1] = g;
        target[2] = b;
    }

    public static void scaleColor(float[] target, float[] source, float scale) {
        target[0] = source[0] * scale;
        target[1] = source[1] * scale;
        target[2] = source[2] * scale;
    }

    public static void setTessellatorColor(Tessellator tessellator, float[] color) {
        tessellator.func_78386_a(color[0], color[1], color[2]);
    }

    public void renderEmptyPlane(int x, int y, int z) {
        this.state.setRenderBounds(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.llHelper.drawFace(0, x, y, z, Blocks.field_150346_d.func_149691_a(0, 0));
    }

    public void setRenderBounds(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        this.state.setRenderBounds(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public void setRenderBounds(double[] bound) {
        this.state.setRenderBounds(bound[0], bound[1], bound[2], bound[3], bound[4], bound[5]);
    }

    public void setRenderBounds(Block block) {
        this.setRenderBounds(block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    public void setColorAndBrightness(IBlockAccess blockAccess, Block block, int x, int y, int z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y, z));
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149720_d(blockAccess, x, y, z));
        RenderHelper.setTessellatorColor(tessellator, this.colorScratch);
    }

    public void renderBlock(IBlockAccess blockAccess, Block block, int meta) {
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149741_i(meta));
        float r = this.colorScratch[0];
        float g = this.colorScratch[1];
        float b = this.colorScratch[2];
        this.renderFace(0, blockAccess, block, block.func_149691_a(0, meta), r, g, b);
        this.renderFace(1, blockAccess, block, block.func_149691_a(1, meta), r, g, b);
        this.renderFace(2, blockAccess, block, block.func_149691_a(2, meta), r, g, b);
        this.renderFace(3, blockAccess, block, block.func_149691_a(3, meta), r, g, b);
        this.renderFace(4, blockAccess, block, block.func_149691_a(4, meta), r, g, b);
        this.renderFace(5, blockAccess, block, block.func_149691_a(5, meta), r, g, b);
    }

    public void renderBlock(IBlockAccess blockAccess, Block block, int x, int y, int z) {
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149720_d(blockAccess, x, y, z));
        float r = this.colorScratch[0];
        float g = this.colorScratch[1];
        float b = this.colorScratch[2];
        this.renderFace(0, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 0), r, g, b);
        this.renderFace(1, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 1), r, g, b);
        this.renderFace(2, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 2), r, g, b);
        this.renderFace(3, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 3), r, g, b);
        this.renderFace(4, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 4), r, g, b);
        this.renderFace(5, blockAccess, block, x, y, z, block.func_149673_e(blockAccess, x, y, z, 5), r, g, b);
    }

    public void renderFace(int face, IBlockAccess blockAccess, Block block, IIcon icon, int meta) {
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149741_i(meta));
        this.renderFaceColorMult(face, blockAccess, block, 0, 0, 0, icon, this.colorScratch[0], this.colorScratch[1], this.colorScratch[2]);
    }

    public void renderFace(int face, IBlockAccess blockAccess, Block block, IIcon icon, float r, float g, float b) {
        this.renderFaceColorMult(face, blockAccess, block, 0, 0, 0, icon, r, g, b);
    }

    public void renderFace(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon) {
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149720_d(blockAccess, x, y, z));
        this.renderFace(face, blockAccess, block, x, y, z, icon, this.colorScratch[0], this.colorScratch[1], this.colorScratch[2]);
    }

    public void renderFace(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, float r, float g, float b) {
        if (Minecraft.func_71379_u() && blockAccess != null && block.getLightValue(blockAccess, x, y, z) == 0) {
            this.renderFaceAOPartial(face, blockAccess, block, x, y, z, icon, r, g, b);
        } else {
            this.renderFaceColorMult(face, blockAccess, block, x, y, z, icon, r, g, b);
        }
    }

    public void renderFaceColorMult(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, float r, float g, float b) {
        this.setupColorMult(face, blockAccess, block, x, y, z, r, g, b);
        face = RenderHelperState.FACE_BY_FACE_ROTATION[face][this.state.rotateTransform];
        this.llHelper.drawFace(face, x, y, z, icon);
        if (blockAccess == null) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public void renderFaceAOPartial(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, float r, float g, float b) {
        this.state.enableAO = true;
        face = RenderHelperState.FACE_BY_FACE_ROTATION[face][this.state.rotateTransform];
        switch (face) {
            case 0: {
                this.aoHelper.setupYNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 1: {
                this.aoHelper.setupYPosAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 2: {
                this.aoHelper.setupZNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 3: {
                this.aoHelper.setupZPosAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 4: {
                this.aoHelper.setupXNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 5: {
                this.aoHelper.setupXPosAOPartial(blockAccess, block, x, y, z, r, g, b);
            }
        }
        this.llHelper.drawFace(face, x, y, z, icon);
        this.state.enableAO = false;
    }

    public void renderPartialFace(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, double uMin, double vMin, double uMax, double vMax) {
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149720_d(blockAccess, x, y, z));
        this.renderPartialFace(face, blockAccess, block, x, y, z, icon, uMin, vMin, uMax, vMax, this.colorScratch[0], this.colorScratch[1], this.colorScratch[2]);
    }

    public void renderPartialFace(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        if (Minecraft.func_71379_u() && blockAccess != null && block.getLightValue(blockAccess, x, y, z) == 0) {
            this.renderPartialFaceAOPartial(face, blockAccess, block, x, y, z, icon, uMin, vMin, uMax, vMax, r, g, b);
        } else {
            this.renderPartialFaceColorMult(face, blockAccess, block, x, y, z, icon, uMin, vMin, uMax, vMax, r, g, b);
        }
    }

    public void renderPartialFaceColorMult(int face, IIcon icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.setupColorMult(face, r, g, b);
        this.renderPartialFace(face, icon, uMin, vMin, uMax, vMax);
        Tessellator.field_78398_a.func_78381_a();
    }

    public void renderPartialFaceColorMult(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.setupColorMult(face, blockAccess, block, x, y, z, r, g, b);
        this.renderPartialFace(face, x, y, z, icon, uMin, vMin, uMax, vMax);
        if (blockAccess == null) {
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public void renderPartialFaceAOPartial(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon, double uMin, double vMin, double uMax, double vMax, float r, float g, float b) {
        this.state.enableAO = true;
        switch (RenderHelperState.FACE_BY_FACE_ROTATION[face][this.state.rotateTransform]) {
            case 0: {
                this.aoHelper.setupYNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 1: {
                this.aoHelper.setupYPosAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 2: {
                this.aoHelper.setupZNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 3: {
                this.aoHelper.setupZPosAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 4: {
                this.aoHelper.setupXNegAOPartial(blockAccess, block, x, y, z, r, g, b);
                break;
            }
            case 5: {
                this.aoHelper.setupXPosAOPartial(blockAccess, block, x, y, z, r, g, b);
            }
        }
        this.renderPartialFace(face, x, y, z, icon, uMin, vMin, uMax, vMax);
        this.state.enableAO = false;
    }

    public void renderPartialFace(int face, IIcon icon, double uMin, double vMin, double uMax, double vMax) {
        this.state.enableAO = false;
        face = RenderHelperState.FACE_BY_FACE_ROTATION[face][this.state.rotateTransform];
        this.llHelper.drawPartialFace(face, 0.0, 0.0, 0.0, icon, uMin, vMin, uMax, vMax);
    }

    public void renderPartialFace(int face, double x, double y, double z, IIcon icon, double uMin, double vMin, double uMax, double vMax) {
        face = RenderHelperState.FACE_BY_FACE_ROTATION[face][this.state.rotateTransform];
        this.llHelper.drawPartialFace(face, x, y, z, icon, uMin, vMin, uMax, vMax);
    }

    public void renderCrossedSquares(Block block, int meta) {
        this.renderCrossedSquares(block, meta, this.getBlockIconFromSideAndMetadata(block, 0, meta));
    }

    public void renderCrossedSquares(Block block, int meta, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(0xF000F0);
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149741_i(meta));
        RenderHelper.setTessellatorColor(tessellator, this.colorScratch);
        boolean lighting = GL11.glIsEnabled((int)2896);
        GL11.glDisable((int)2896);
        tessellator.func_78382_b();
        this.drawCrossedSquares(icon, 0.0, 0.0, 0.0, 1.0f);
        tessellator.func_78381_a();
        if (lighting) {
            GL11.glEnable((int)2896);
        }
    }

    public void renderCrossedSquares(IBlockAccess blockAccess, Block block, int x, int y, int z) {
        this.renderCrossedSquares(blockAccess, block, x, y, z, this.getBlockIconFromSideAndMetadata(block, 0, blockAccess.func_72805_g(x, y, z)));
    }

    public void renderCrossedSquares(IBlockAccess blockAccess, Block block, int x, int y, int z, IIcon icon) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(block.func_149677_c(blockAccess, x, y, z));
        RenderHelper.calculateBaseColor(this.colorScratch, block.func_149720_d(blockAccess, x, y, z));
        RenderHelper.setTessellatorColor(tessellator, this.colorScratch);
        this.drawCrossedSquares(icon, x, y, z, 1.0f);
    }

    public void drawCrossedSquares(IIcon icon, double x, double y, double z, float scale) {
        Tessellator tessellator = Tessellator.field_78398_a;
        x += this.state.renderOffsetX;
        y += this.state.renderOffsetY;
        z += this.state.renderOffsetZ;
        double uMin = icon.func_94214_a(this.state.renderMinX * 16.0);
        double uMax = icon.func_94214_a(this.state.renderMaxX * 16.0);
        double vMin = icon.func_94207_b(16.0 - this.state.renderMaxY * 16.0);
        double vMax = icon.func_94207_b(16.0 - this.state.renderMinY * 16.0);
        double d7 = 0.45 * (double)scale;
        double xMin = x + 0.5 - d7;
        double xMax = x + 0.5 + d7;
        double yMin = y + this.state.renderMinY * (double)scale;
        double yMax = y + this.state.renderMaxY * (double)scale;
        double zMin = z + 0.5 - d7;
        double zMax = z + 0.5 + d7;
        tessellator.func_78374_a(xMin, yMax, zMin, uMin, vMin);
        tessellator.func_78374_a(xMin, yMin, zMin, uMin, vMax);
        tessellator.func_78374_a(xMax, yMin, zMax, uMax, vMax);
        tessellator.func_78374_a(xMax, yMax, zMax, uMax, vMin);
        tessellator.func_78374_a(xMax, yMax, zMax, uMin, vMin);
        tessellator.func_78374_a(xMax, yMin, zMax, uMin, vMax);
        tessellator.func_78374_a(xMin, yMin, zMin, uMax, vMax);
        tessellator.func_78374_a(xMin, yMax, zMin, uMax, vMin);
        tessellator.func_78374_a(xMin, yMax, zMax, uMin, vMin);
        tessellator.func_78374_a(xMin, yMin, zMax, uMin, vMax);
        tessellator.func_78374_a(xMax, yMin, zMin, uMax, vMax);
        tessellator.func_78374_a(xMax, yMax, zMin, uMax, vMin);
        tessellator.func_78374_a(xMax, yMax, zMin, uMin, vMin);
        tessellator.func_78374_a(xMax, yMin, zMin, uMin, vMax);
        tessellator.func_78374_a(xMin, yMin, zMax, uMax, vMax);
        tessellator.func_78374_a(xMin, yMax, zMax, uMax, vMin);
    }

    public void drawCrossedSquaresBounded(IIcon icon, double x, double y, double z, float scale) {
        Tessellator tessellator = Tessellator.field_78398_a;
        x += this.state.renderOffsetX;
        y += this.state.renderOffsetY;
        z += this.state.renderOffsetZ;
        double vMin = icon.func_94207_b(16.0 - this.state.renderMaxY * 16.0);
        double vMax = icon.func_94207_b(16.0 - this.state.renderMinY * 16.0);
        double xzNN = Math.max(this.state.renderMinX, this.state.renderMinZ);
        double xzPP = Math.min(this.state.renderMaxX, this.state.renderMaxZ);
        double xNN = x + 0.5 - (0.5 - xzNN) * 0.9;
        double zNN = z + 0.5 - (0.5 - xzNN) * 0.9;
        double xNP = x + 0.5 - (0.5 - Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ)) * 0.9;
        double zNP = z + 0.5 - (0.5 - Math.min(1.0 - this.state.renderMinX, this.state.renderMaxZ)) * 0.9;
        double xPN = x + 0.5 - (0.5 - Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ)) * 0.9;
        double zPN = z + 0.5 - (0.5 - Math.max(1.0 - this.state.renderMaxX, this.state.renderMinZ)) * 0.9;
        double xPP = x + 0.5 - (0.5 - xzPP) * 0.9;
        double zPP = z + 0.5 - (0.5 - xzPP) * 0.9;
        double yMin = y + this.state.renderMinY * (double)scale;
        double yMax = y + this.state.renderMaxY * (double)scale;
        double uNN = icon.func_94214_a(xzNN * 16.0);
        double uPP = icon.func_94214_a(xzPP * 16.0);
        tessellator.func_78374_a(xNN, yMax, zNN, uNN, vMin);
        tessellator.func_78374_a(xNN, yMin, zNN, uNN, vMax);
        tessellator.func_78374_a(xPP, yMin, zPP, uPP, vMax);
        tessellator.func_78374_a(xPP, yMax, zPP, uPP, vMin);
        uNN = icon.func_94214_a(16.0 - xzNN * 16.0);
        uPP = icon.func_94214_a(16.0 - xzPP * 16.0);
        tessellator.func_78374_a(xPP, yMax, zPP, uPP, vMin);
        tessellator.func_78374_a(xPP, yMin, zPP, uPP, vMax);
        tessellator.func_78374_a(xNN, yMin, zNN, uNN, vMax);
        tessellator.func_78374_a(xNN, yMax, zNN, uNN, vMin);
        double uNP = icon.func_94214_a(Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ) * 16.0);
        double uPN = icon.func_94214_a(Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ) * 16.0);
        tessellator.func_78374_a(xNP, yMax, zNP, uNP, vMin);
        tessellator.func_78374_a(xNP, yMin, zNP, uNP, vMax);
        tessellator.func_78374_a(xPN, yMin, zPN, uPN, vMax);
        tessellator.func_78374_a(xPN, yMax, zPN, uPN, vMin);
        uNP = icon.func_94214_a(16.0 - Math.max(this.state.renderMinX, 1.0 - this.state.renderMaxZ) * 16.0);
        uPN = icon.func_94214_a(16.0 - Math.min(this.state.renderMaxX, 1.0 - this.state.renderMinZ) * 16.0);
        tessellator.func_78374_a(xPN, yMax, zPN, uPN, vMin);
        tessellator.func_78374_a(xPN, yMin, zPN, uPN, vMax);
        tessellator.func_78374_a(xNP, yMin, zNP, uNP, vMax);
        tessellator.func_78374_a(xNP, yMax, zNP, uNP, vMin);
    }

    private void setupColorMult(int face, float r, float g, float b) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] norm = normMap[face];
        float scale = this.state.getColorMult(face);
        tessellator.func_78386_a(scale * r, scale * g, scale * b);
        tessellator.func_78382_b();
        tessellator.func_78375_b(norm[0], norm[1], norm[2]);
        this.state.enableAO = false;
    }

    private void setupColorMult(int face, IBlockAccess blockAccess, Block block, int x, int y, int z, float r, float g, float b) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float[] norm = normMap[face];
        float scale = this.state.getColorMult(face);
        if (blockAccess == null) {
            tessellator.func_78382_b();
            tessellator.func_78386_a(r, g, b);
            tessellator.func_78375_b(norm[0], norm[1], norm[2]);
        } else {
            int brightX = x;
            int brightY = y;
            int brightZ = z;
            switch (face) {
                case 0: {
                    brightY = this.state.renderMinY > 0.0 ? y : y - 1;
                    break;
                }
                case 1: {
                    brightY = this.state.renderMaxY < 1.0 ? y : y + 1;
                    break;
                }
                case 2: {
                    brightZ = this.state.renderMinZ > 0.0 ? z : z - 1;
                    break;
                }
                case 3: {
                    brightZ = this.state.renderMaxZ < 1.0 ? z : z + 1;
                    break;
                }
                case 4: {
                    brightX = this.state.renderMinX > 0.0 ? x : x - 1;
                    break;
                }
                case 5: {
                    brightX = this.state.renderMaxX < 1.0 ? x : x + 1;
                }
            }
            tessellator.func_78386_a(scale * r, scale * g, scale * b);
            tessellator.func_78380_c(block.func_149677_c(blockAccess, brightX, brightY, brightZ));
        }
        this.state.enableAO = false;
    }

    private IIcon getBlockIconFromSideAndMetadata(Block block, int side, int meta) {
        return this.getIconSafe(block.func_149691_a(side, meta));
    }

    private IIcon getIconSafe(IIcon icon) {
        if (icon == null) {
            return ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }
}

