/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventoryLogic;
import mantle.blocks.abstracts.InventorySlab;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.logic.CraftingStationLogic;
import tconstruct.tools.logic.PartBuilderLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.StencilTableLogic;
import tconstruct.tools.logic.ToolForgeLogic;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.util.config.PHConstruct;

public class CraftingSlab
extends InventorySlab {
    public CraftingSlab(Material material) {
        super(material);
        this.func_149647_a(TConstructRegistry.blockTab);
        this.func_149711_c(2.0f);
        this.field_149762_H = Block.field_149766_f;
    }

    public String[] getTextureNames() {
        return new String[]{"craftingstation_top", "craftingstation_slab_side", "craftingstation_bottom", "toolstation_top", "toolstation_slab_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_slab_side", "partbuilder_oak_bottom", "stenciltable_oak_top", "stenciltable_slab_side", "stenciltable_oak_bottom", "patternchest_top", "patternchest_slab_side", "patternchest_bottom", "toolforge_top", "toolforge_slab_side", "toolforge_top"};
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F - 0.125), (double)((double)z + this.field_149757_G));
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public TileEntity createTileEntity(World world, int metadata) {
        InventoryLogic inventoryLogic;
        switch (metadata % 8) {
            case 0: {
                inventoryLogic = new CraftingStationLogic();
                break;
            }
            case 1: {
                inventoryLogic = new ToolStationLogic();
                break;
            }
            case 2: {
                inventoryLogic = new PartBuilderLogic();
                break;
            }
            case 3: {
                inventoryLogic = new StencilTableLogic();
                break;
            }
            case 4: {
                inventoryLogic = new PatternChestLogic();
                break;
            }
            case 5: {
                inventoryLogic = new ToolForgeLogic();
                break;
            }
            default: {
                inventoryLogic = null;
            }
        }
        return inventoryLogic;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        Integer n;
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: {
                n = 11;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void func_149666_a(Item b, CreativeTabs tab, List<ItemStack> list) {
        for (int iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(b, 1, iter));
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        int meta;
        boolean keptInventory = false;
        if (stack.func_77942_o()) {
            NBTTagCompound inventory = stack.func_77978_p().func_74775_l("Inventory");
            TileEntity te = world.func_147438_o(x, y, z);
            if (inventory != null && te instanceof PatternChestLogic) {
                PatternChestLogic logic = (PatternChestLogic)te;
                logic.readInventoryFromNBT(inventory);
                logic.field_145851_c = x;
                logic.field_145848_d = y;
                logic.field_145849_e = z;
                keptInventory = true;
            }
        }
        if (!keptInventory && PHConstruct.freePatterns && (meta = world.func_72805_g(x, y, z)) == 4) {
            PatternChestLogic logic = (PatternChestLogic)world.func_147438_o(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.func_70299_a(i - 1, new ItemStack(TinkerTools.woodPattern, 1, i));
            }
            logic.func_70299_a(13, new ItemStack(TinkerTools.woodPattern, 1, 22));
        }
        super.func_149689_a(world, x, y, z, entityliving, stack);
    }

    public TileEntity func_149915_a(World var1, int metadata) {
        InventoryLogic inventoryLogic;
        switch (metadata % 8) {
            case 0: {
                inventoryLogic = new CraftingStationLogic();
                break;
            }
            case 1: {
                inventoryLogic = new ToolStationLogic();
                break;
            }
            case 2: {
                inventoryLogic = new PartBuilderLogic();
                break;
            }
            case 3: {
                inventoryLogic = new StencilTableLogic();
                break;
            }
            case 4: {
                inventoryLogic = new PatternChestLogic();
                break;
            }
            case 5: {
                inventoryLogic = new ToolForgeLogic();
                break;
            }
            default: {
                inventoryLogic = null;
            }
        }
        return inventoryLogic;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        int meta;
        player.func_71020_j(0.025f);
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (meta = world.func_72805_g(x, y, z)) == 4) {
            ItemStack chest = new ItemStack((Block)this, 1, 4);
            NBTTagCompound inventory = new NBTTagCompound();
            PatternChestLogic logic = (PatternChestLogic)world.func_147438_o(x, y, z);
            logic.writeInventoryToNBT(inventory);
            NBTTagCompound baseTag = new NBTTagCompound();
            baseTag.func_74782_a("Inventory", (NBTBase)inventory);
            chest.func_77982_d(baseTag);
            for (int i = 0; i < logic.func_70302_i_(); ++i) {
                logic.func_70299_a(i, null);
            }
            if (!player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, chest);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta != 4) {
            super.func_149636_a(world, player, x, y, z, meta);
        }
    }
}

