/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;
import tconstruct.tools.inventory.ToolStationContainer;
import tconstruct.tools.logic.ToolStationLogic;

public class ToolStationPacket
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private String toolName;

    public ToolStationPacket() {
    }

    public ToolStationPacket(int x, int y, int z, String toolName) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.toolName = toolName;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.toolName);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.toolName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        if (player.field_71070_bA instanceof ToolStationContainer) {
            ToolStationContainer container = (ToolStationContainer)player.field_71070_bA;
            ToolStationLogic logic = container.logic;
            if (logic != null && logic.field_145851_c == this.x && logic.field_145848_d == this.y && logic.field_145849_e == this.z) {
                logic.setToolname(this.toolName);
            }
        }
    }
}

