/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.event.PartBuilderEvent;
import tconstruct.library.event.SmelteryCastEvent;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.library.weaponry.ArrowShaftMaterial;
import tconstruct.library.weaponry.BowBaseAmmo;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.weapons.Crossbow;
import tconstruct.weaponry.weapons.LongBow;
import tconstruct.weaponry.weapons.ShortBow;

public class WeaponryHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (!event.player.field_70170_p.field_72995_K && item == Item.func_150898_a((Block)TinkerTools.toolStationWood)) {
            if (!PHConstruct.beginnerBook) {
                return;
            }
            TPlayerStats stats = TPlayerStats.get(event.player);
            if (!stats.weaponryManual) {
                stats.weaponryManual = true;
                AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 4));
            }
        }
    }

    @SubscribeEvent
    public void onAmmoCrafted(ToolCraftEvent.NormalTool event) {
        if (!(event.tool instanceof IAmmo)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.func_74775_l("InfiTool");
        if (event.tool instanceof ArrowAmmo) {
            ToolMaterial head = TConstructRegistry.getMaterial(tags.func_74762_e("Head"));
            ArrowMaterial arrow = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Head"));
            ArrowShaftMaterial shaft = (ArrowShaftMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Handle"), ArrowShaftMaterial.class);
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchlingLeafMaterial.class);
            }
            if (arrow == null || shaft == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)head.durability() * shaft.durabilityModifier * fletching.durabilityModifier);
            float weight = arrow.mass + shaft.weight;
            float accuracy = fletching.accuracy;
            float breakChance = shaft.fragility * arrow.breakChance + fletching.breakChance;
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, head.shoddy(), head.reinforced());
            if (tags.func_74762_e("Handle") == 3) {
                tags.func_74768_a("Fiery", 5);
            }
            int mods = Math.max(0, tags.func_74762_e("Modifiers") - 1);
            tags.func_74768_a("Modifiers", mods);
        } else if (event.tool instanceof BoltAmmo) {
            ToolMaterial headMat = TConstructRegistry.getMaterial(tags.func_74762_e("Head"));
            ToolMaterial coreMat = TConstructRegistry.getMaterial(tags.func_74762_e("Handle"));
            ArrowMaterial head = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Head"));
            ArrowMaterial core = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchlingLeafMaterial.class);
            }
            if (head == null || core == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)headMat.durability() * coreMat.handleDurability() * fletching.durabilityModifier);
            float weight = head.mass + core.mass * 1.5f;
            float accuracy = (100.0f + fletching.accuracy) / 2.0f;
            float breakChance = (fletching.breakChance * 2.0f + 0.15f * core.breakChance) * head.breakChance / 2.0f;
            float shoddy = (headMat.shoddy() + coreMat.shoddy()) / 2.0f;
            int reinforced = Math.max(headMat.reinforced(), coreMat.reinforced());
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, shoddy, reinforced);
            int mods = Math.max(0, tags.func_74762_e("Modifiers") - 1);
            tags.func_74768_a("Modifiers", mods);
        }
        IAmmo ammoItem = (IAmmo)((Object)event.tool);
        tags.func_74768_a("Ammo", ammoItem.getMaxAmmo(tags));
    }

    @SubscribeEvent
    public void onProjectileWeaponCrafted(ToolCraftEvent.NormalTool event) {
        boolean enchanted;
        float flightSpeed;
        int drawSpeed;
        if (!(event.tool instanceof ProjectileWeapon)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.func_74775_l("InfiTool");
        ProjectileWeapon weapon = (ProjectileWeapon)event.tool;
        if (event.tool instanceof BowBaseAmmo) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.func_74762_e("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(tags.func_74762_e("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Handle"), BowstringMaterial.class);
            if (top == null || bottom == null || string == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            drawSpeed = (int)((float)(top.drawspeed + bottom.drawspeed) / 2.0f * string.drawspeedModifier);
            flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
            if (event.tool instanceof ShortBow) {
                drawSpeed = (int)((double)drawSpeed * 0.9);
            }
            if (event.tool instanceof LongBow) {
                drawSpeed = (int)((float)drawSpeed * 1.8f);
                flightSpeed *= 1.5f;
            }
            enchanted = tags.func_74762_e("Handle") == 1;
        } else if (event.tool instanceof Crossbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.func_74762_e("Head"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), BowstringMaterial.class);
            if (top == null || string == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            drawSpeed = (int)((float)top.drawspeed * string.drawspeedModifier);
            flightSpeed = top.flightSpeedMax * string.flightSpeedModifier;
            drawSpeed = (int)((float)drawSpeed * 2.5f);
            drawSpeed = (int)((float)drawSpeed - (float)drawSpeed * 0.25f);
            flightSpeed = (float)((double)flightSpeed * 1.5);
            enchanted = tags.func_74762_e("Accessory") == 1;
        } else {
            return;
        }
        if (enchanted) {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", ++modifiers);
        }
        tags.func_74768_a("DrawSpeed", drawSpeed);
        tags.func_74768_a("BaseDrawSpeed", drawSpeed);
        tags.func_74776_a("FlightSpeed", flightSpeed);
    }

    @SubscribeEvent
    public void buildArrow(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null || event.accessoryStack == null) {
            return;
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(event.handleStack, ArrowShaftMaterial.class);
        if (mat == null) {
            return;
        }
        Item extra = event.extraStack != null ? event.extraStack.func_77973_b() : null;
        ToolCore tool = ToolBuilder.instance.getMatchingRecipe(event.headStack.func_77973_b(), mat.craftingItem.func_77973_b(), event.accessoryStack.func_77973_b(), extra);
        if (tool == TinkerWeaponry.arrowAmmo) {
            event.handleStack = mat.craftingItem.func_77946_l();
        }
    }

    @SubscribeEvent
    public void buildBolt(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null) {
            return;
        }
        if (event.headStack.func_77973_b() != TinkerWeaponry.partBolt) {
            return;
        }
        if (event.accessoryStack != null && event.headStack.func_77973_b() == TinkerWeaponry.partBolt && event.handleStack.func_77973_b() == TinkerWeaponry.partBolt && event.accessoryStack.func_77973_b() == TinkerWeaponry.fletching) {
            return;
        }
        ItemStack bolt1 = event.headStack.func_77946_l();
        ItemStack bolt2 = event.headStack;
        ItemStack fletching = event.handleStack;
        DualMaterialToolPart dualPart = (DualMaterialToolPart)bolt2.func_77973_b();
        bolt1.func_77964_b(dualPart.getMaterialID2(bolt1));
        event.headStack = bolt1;
        event.handleStack = bolt2;
        event.accessoryStack = fletching;
    }

    private void setAmmoData(NBTTagCompound tags, int durability, float weight, float breakChance, float accuracy, float shoddy, int reinforced) {
        tags.func_74768_a("TotalDurability", durability);
        tags.func_74768_a("BaseDurability", durability);
        tags.func_74776_a("Mass", weight);
        tags.func_74776_a("BreakChance", breakChance);
        tags.func_74776_a("Accuracy", accuracy);
        tags.func_74776_a("Shoddy", shoddy);
        tags.func_74768_a("Unbreaking", reinforced);
    }

    @SubscribeEvent
    public void weaponryPartCrafted(PartBuilderEvent.NormalPart event) {
        PatternBuilder.MaterialSet ms;
        PatternBuilder.ItemKey key;
        if (event.pattern == null) {
            return;
        }
        if (event.pattern.func_77973_b() == TinkerWeaponry.woodPattern && (event.pattern.func_77960_j() == 1 || event.pattern.func_77960_j() == 3)) {
            key = PatternBuilder.instance.getItemKey(event.material);
            if (key == null) {
                return;
            }
            ms = PatternBuilder.instance.materialSets.get(key.key);
            if (ms == null) {
                return;
            }
            if (TConstructRegistry.getBowMaterial(ms.materialID) == null) {
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.pattern.func_77973_b() == TinkerTools.woodPattern && event.pattern.func_77960_j() == 25) {
            key = PatternBuilder.instance.getItemKey(event.material);
            if (key == null) {
                return;
            }
            ms = PatternBuilder.instance.materialSets.get(key.key);
            if (ms == null) {
                return;
            }
            if (TConstructRegistry.getArrowMaterial(ms.materialID) == null) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void weaponryPartCast(SmelteryCastEvent.CastingTable event) {
        if (event.recipe == null || event.recipe.output == null) {
            return;
        }
        if (!(event.recipe.output.func_77973_b() instanceof IToolPart)) {
            return;
        }
        int mat = ((IToolPart)event.recipe.output.func_77973_b()).getMaterialID(event.recipe.output);
        if (event.recipe.output.func_77973_b() == TinkerWeaponry.arrowhead && TConstructRegistry.getArrowMaterial(mat) == null) {
            event.setResult(Event.Result.DENY);
        }
        if ((event.recipe.output.func_77973_b() == TinkerWeaponry.partBowLimb || event.recipe.output.func_77973_b() == TinkerWeaponry.partCrossbowLimb) && TConstructRegistry.getBowMaterial(mat) == null) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void boneanaParts(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null || event.accessoryStack != null || event.extraStack != null) {
            return;
        }
        if (event.headStack.func_77973_b() == Items.field_151150_bK && event.handleStack.func_77973_b() == Items.field_151103_aS) {
            if (!(event.headStack.func_77942_o() && event.headStack.func_77978_p().func_74764_b("display") && event.headStack.func_77978_p().func_74775_l("display").func_74764_b("Name") && event.headStack.func_77978_p().func_74775_l("display").func_74779_i("Name").equalsIgnoreCase("banana"))) {
                return;
            }
            event.name = "\u2400Bon\u00e6na";
            event.headStack = new ItemStack(TinkerTools.swordBlade, 1, 5);
            event.handleStack = new ItemStack(TinkerTools.toolRod, 1, 5);
            event.accessoryStack = new ItemStack(TinkerTools.wideGuard, 1, 5);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void boneanaBuilding(ToolCraftEvent.NormalTool event) {
        if ("\u00a7f\u2400Bon\u00e6na".equals(event.toolTag.func_74775_l("display").func_74779_i("Name"))) {
            event.toolTag.func_74775_l("display").func_74778_a("Name", EnumChatFormatting.YELLOW + "Bon\u00e6na");
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString(StatCollector.func_74838_a((String)"tool.boneana.lore")));
            event.toolTag.func_74775_l("display").func_74782_a("Lore", (NBTBase)lore);
            NBTTagCompound tag = event.toolTag.func_74775_l("InfiTool");
            tag.func_74757_a("Special", true);
            tag.func_74768_a("Attack", 4);
            tag.func_74768_a("TotalDurability", 600);
            tag.func_74768_a("BaseDurability", 600);
            tag.func_74776_a("Shoddy", -2.0f);
            tag.func_74768_a("MiningSpeed", 1);
            tag.func_74768_a("HarvestLevel", 0);
            tag.func_74768_a("Modifiers", 0);
            ItemStack weapon = new ItemStack((Item)TinkerWeaponry.boneana);
            weapon.func_77982_d(event.toolTag);
            event.overrideResult(weapon);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void entityJoin(EntityJoinWorldEvent event) {
        if (event.entity instanceof ProjectileBase) {
            ProjectileBase projectile = (ProjectileBase)event.entity;
            if (projectile.returnStack == null || !(projectile.returnStack.func_77973_b() instanceof ToolCore)) {
                event.setCanceled(true);
            }
        }
    }
}

