/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world;

import com.kuba6000.mobsinfo.api.ConstructableItemStack;
import com.kuba6000.mobsinfo.api.IMobExtraInfoProvider;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import tconstruct.TConstruct;
import tconstruct.tools.TinkerTools;
import tconstruct.util.ItemHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;

@Optional.Interface(iface="com.kuba6000.mobsinfo.api.IMobExtraInfoProvider", modid="mobsinfo")
public class TinkerWorldEvents
implements IMobExtraInfoProvider {
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase living = event.entityLiving;
        if (living.getClass() == EntitySpider.class && TConstruct.random.nextInt(100) == 0) {
            EntityCreeper creeper = new EntityCreeper(living.field_70170_p);
            TinkerWorldEvents.spawnEntityLiving(living.field_70165_t, living.field_70163_u + 1.0, living.field_70161_v, (EntityLiving)creeper, living.field_70170_p);
            if (living.field_70153_n != null) {
                creeper.func_70078_a(living.field_70153_n);
            } else {
                creeper.func_70078_a((Entity)living);
            }
            EntityXPOrb orb = new EntityXPOrb(living.field_70170_p, living.field_70165_t, living.field_70163_u, living.field_70161_v, TConstruct.random.nextInt(20) + 20);
            orb.func_70078_a((Entity)creeper);
        }
    }

    public static void spawnEntityLiving(double x, double y, double z, EntityLiving entity, World world) {
        if (!world.field_72995_K) {
            entity.func_70107_b(x, y, z);
            entity.func_110161_a(null);
            world.func_72838_d((Entity)entity);
        }
    }

    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K && event.block == TinkerWorld.slimeSapling) {
            if (TinkerWorld.slimeSapling.boneFertilize(event.world, event.x, event.y, event.z, event.world.field_73012_v, event.entityPlayer)) {
                event.setResult(Event.Result.ALLOW);
            } else {
                event.setCanceled(true);
            }
        }
    }

    public void onHurt(LivingHurtEvent event) {
        EntityLivingBase target;
        Entity attacker;
        EntityLivingBase reciever = event.entityLiving;
        if (reciever instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ItemStack stack = player.func_71045_bC();
            if (stack != null && player.func_71039_bw()) {
                Item item = stack.func_77973_b();
                if (item == TinkerTools.cutlass) {
                    player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
                } else if (item == TinkerTools.battlesign) {
                    event.ammount = (float)((double)event.ammount * 1.5);
                }
            }
        } else if (reciever instanceof EntityCreeper && (attacker = event.source.func_76346_g()) instanceof EntityLivingBase && (target = ((EntityCreeper)reciever).func_70638_az()) != null) {
            float d1 = reciever.func_70032_d((Entity)((EntityCreeper)reciever).func_70638_az());
            float d2 = reciever.func_70032_d(attacker);
            if (d2 < d1) {
                ((EntityCreeper)event.entityLiving).func_70624_b((EntityLivingBase)event.source.func_76346_g());
            }
        }
    }

    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving == null) {
            return;
        }
        if (event.entityLiving.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (EntityItem o : event.drops) {
                    if (o.func_92059_d().func_77973_b() != Items.field_151073_bk) continue;
                    o.func_92058_a(new ItemStack(Items.field_151043_k, 1));
                }
            } else {
                ItemHelper.addDrops(event, new ItemStack(Items.field_151073_bk, 1));
            }
        }
    }

    @Optional.Method(modid="mobsinfo")
    public void provideExtraDropsInformation(@Nonnull String entityString, @Nonnull ArrayList<MobDrop> drops, @Nonnull MobRecipe recipe) {
        block4: {
            if (recipe.entity.getClass() != EntityGhast.class) break block4;
            if (PHConstruct.uhcGhastDrops) {
                for (MobDrop drop : drops) {
                    if (drop.stack.func_77973_b() != Items.field_151073_bk) continue;
                    drop.stack = new ItemStack(Items.field_151043_k);
                    drop.reconstructableStack = new ConstructableItemStack(drop.stack);
                }
            } else {
                for (MobDrop drop : drops) {
                    if (drop.stack.func_77973_b() != Items.field_151073_bk) continue;
                    drop.chance += 10000;
                    drop.clampChance();
                }
            }
        }
    }

    public class EventHandler {
        @SubscribeEvent
        public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
            TinkerWorldEvents.this.onLivingSpawn(event);
        }

        @SubscribeEvent
        public void bonemealEvent(BonemealEvent event) {
            TinkerWorldEvents.this.bonemealEvent(event);
        }

        @SubscribeEvent
        public void onHurt(LivingHurtEvent event) {
            TinkerWorldEvents.this.onHurt(event);
        }

        @SubscribeEvent
        public void onLivingDrop(LivingDropsEvent event) {
            TinkerWorldEvents.this.onLivingDrop(event);
        }
    }
}

